package hello;

import java.math.*;
import javax.xml.rpc.Call;
import javax.xml.rpc.Service;
import javax.xml.rpc.JAXRPCException;
import javax.xml.namespace.QName;
import javax.xml.rpc.ServiceFactory;
import javax.xml.rpc.ParameterMode;

public class DIINoWSDLHelloClient
{

    // In the WSDL under definitions. This is the target namespace.
    private static String BODY_NAMESPACE_VALUE =
            "http://hello.org/wsdl";

    // In the WSDL under types. This is the namespace that is defined for
    // types defined in the WSDL.
    private static String TYPE_NAMESPACE_VALUE =
             "http://hello.org/types";

    private static String ENCODING_STYLE_PROPERTY =
            "javax.xml.rpc.encodingstyle.namespace.uri";
    private static String NS_XSD =
            "http://www.w3.org/2001/XMLSchema";
    private static String URI_ENCODING =
            "http://schemas.xmlsoap.org/soap/encoding/";

    // The endpoint must be supplied by the service deployer or developer.
    // It may also be found in the WSDL under address.
    String endpoint =
            "http://localhost:8080/jaxrpc-DocumentLitHelloService/hello";

    // Service name from the WSDL.
    String serviceName = "HelloWorldService";

    // Port name from the WSDL.
    String portName = "HelloIFPort";

    Service service = null;
    QName port = null;

    ValueType valueType = null;

    public static void main(String[] args)
    {
        try {
            DIINoWSDLHelloClient client =  new DIINoWSDLHelloClient();
            client.testEchoString();
            client.testValueType();
            client.testComplexValueType();
            client.testSimpleIntArray();
        } catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public DIINoWSDLHelloClient() {
        try {

           // Get the service factory using the newInstance() method.
            ServiceFactory factory =
                    ServiceFactory.newInstance();

            // Create the service using the QName of the service.
	    // Since the WSDL is not being read at runtime this service
	    // is not configured.
            service =
                    factory.createService(new QName(serviceName));

            // Specify the port QName using the portName.
            port = new QName(portName);

        } catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void testEchoString()
    throws Exception
    {

    // Operation QName as specified in the WSDL under portType section.
    // WSDL fragment:
    // <operation name="sayHello">
    // <input message="tns:HelloIF_sayHello"/>
    // <output message="tns:HelloIF_sayHelloResponse"/></operation>
      QName operation = new QName(BODY_NAMESPACE_VALUE, "sayHello");

    // The service is a factory for a call that will be invoked.
    // In the case when not using deployed WSDL during runtime,
    // the call will need to be configured by the developer
    // using data defined in the WSDL.
        Call call = service.createCall(port, operation);

    // The developer must set the endpoint address.
        call.setTargetEndpointAddress(endpoint);

    // For a call object, the developer must set these Call properties.
        call.setProperty(Call.SOAPACTION_USE_PROPERTY,
                new Boolean(true));
        call.setProperty(Call.SOAPACTION_URI_PROPERTY, "");

    // The encoding style property and the operation style property
    // must be set for a WS-I doc/lit or rpc/lit type of invocation
    // Although these properties are specified in the JAX-RPC Specification
    // as optional, the default behavior for this implementation is rpc/encoded.

    // use="literal" in WSDL
        call.setProperty(ENCODING_STYLE_PROPERTY, "");
    // style="document" in WSDL
        call.setProperty(Call.OPERATION_STYLE_PROPERTY, "document");


    // Specify the QName of the request parameter. This is defined in the WSDL
    // in the types section. Thus, the QName prefix for the parameter is
    // the TYPE_NAMESPACE_VALUE.
    // WSDL Fragment:
    // <message name="HelloIF_sayHello">
        // <part name="parameters" element="ns2:sayHello"/></message>
        QName REQUEST_QNAME = new QName(TYPE_NAMESPACE_VALUE, "sayHello");

    // Add the parameter to the call object. This version of the addParameter() method
    // has four arguments. When not using WSDL at run-time and when invoking call objects
    // with more complex types, it is always best to specify the parameter class.
    // Note that the first argument is the part name of the sayHello parameter as defined in the
    // WSDL.
        call.addParameter("parameters", REQUEST_QNAME, hello.SayHello.class,
                ParameterMode.IN);

    // Add the return type to the call. To reiterate, it is highly recommended that when
    // not using a WSDL at runtime to create the Service information, set the return class type.
    // If this is not done, it is very difficult for the JAX-RPC implementation to determine the
    // return type class
        QName RESPONSE_QNAME = new QName(TYPE_NAMESPACE_VALUE, "sayHelloResponse");
        call.setReturnType(RESPONSE_QNAME, hello.SayHelloResponse.class);

    // Instantiate the parameter(s) and populate the call Object[] request.
    // Where does the SayHello class come from?. This class must previously be generated by
    // the wscompile tool. The client programmer does not necessarily need to generate these
    // files-- the JAX-RPC service developer may have made them available after service development
    // and deployment. These files should not be coded by the client developer.
        System.out.println("Running echo String from a dii client.");
        SayHello request = new SayHello(" Duke says: ", "Java is Everywhere!");
        Object[] params = {request};

    // Invoke sayHello:
        SayHelloResponse response = (SayHelloResponse) call.invoke(params);

    // Print result.
        System.out.println("Response is: " + response.getResult());
        System.out.println(" ");

    }

    public void testValueType()
    throws Exception
    {
        QName operation = new QName(BODY_NAMESPACE_VALUE, "changeValueType");

    // This version of the createCall() method supplies only the port
    // QName as a parameter. The call operation QName must also be configured
    // on the call object
        Call call = service.createCall(port);

        call.setTargetEndpointAddress(endpoint);

        call.setOperationName(operation);
        call.setProperty(Call.SOAPACTION_USE_PROPERTY,
                new Boolean(true));
        call.setProperty(Call.SOAPACTION_URI_PROPERTY, "");
            call.setProperty(ENCODING_STYLE_PROPERTY, "");
        call.setProperty(Call.OPERATION_STYLE_PROPERTY, "document");

        QName REQUEST_QNAME = new QName(TYPE_NAMESPACE_VALUE, "changeValueType");

        call.addParameter("parameters", REQUEST_QNAME, hello.ChangeValueType.class,
                ParameterMode.IN);
        QName RESPONSE_QNAME = new QName(TYPE_NAMESPACE_VALUE, "changeValueTypeResponse");
        call.setReturnType(RESPONSE_QNAME, hello.ChangeValueTypeResponse.class);

        System.out.println("\nRunning SimpleValueType from a dii client using Parameter configuration");
        System.out.println("");
        System.out.println("Original ValueType is: ");
        valueType = new ValueType(true, new Integer(23), "Test Data");
        System.out.println("Echoing the boolean set in ValueType by client :" + valueType.isBoolProperty());
        System.out.println("Echoing the integer set in ValueType by client :" + valueType.getIntegerProperty().intValue());
        System.out.println("Echoing the string set in ValueType by client  :" + valueType.getStringProperty());
        System.out.println("");

        ChangeValueType changeValueType = new ChangeValueType(valueType);

        Object[] params = {changeValueType};

        //  Invoke changeValueType:
        ChangeValueTypeResponse valueTypeResponse = (ChangeValueTypeResponse) call.invoke(params);

        ValueType vt = valueTypeResponse.getResult();
        System.out.println("The response from the Server is:");
        System.out.println("Echoing the boolean set in ValueType by server :" + vt.isBoolProperty());
        System.out.println("Echoing the integer set in ValueType by server :" + vt.getIntegerProperty().intValue());
        System.out.println("Echoing the string set in ValueType by server  :" + vt.getStringProperty());

    }

    public void testComplexValueType()
    throws Exception
    {

        QName operation = new QName(BODY_NAMESPACE_VALUE, "changeComplexValueType");

        Call call = service.createCall(port, operation);

        call.setTargetEndpointAddress(endpoint);

        call.setProperty(Call.SOAPACTION_USE_PROPERTY,
                new Boolean(true));
        call.setProperty(Call.SOAPACTION_URI_PROPERTY, "");
            call.setProperty(ENCODING_STYLE_PROPERTY, "");
        call.setProperty(Call.OPERATION_STYLE_PROPERTY, "document");

        QName REQUEST_QNAME = new QName(TYPE_NAMESPACE_VALUE, "changeComplexValueType");

        call.addParameter("parameters", REQUEST_QNAME, hello.ChangeComplexValueType.class,
           ParameterMode.IN);
        QName RESPONSE_QNAME = new QName(TYPE_NAMESPACE_VALUE, "changeComplexValueTypeResponse");
        call.setReturnType(RESPONSE_QNAME, hello.ChangeComplexValueTypeResponse.class);

        System.out.println("Running ChangeComplexValueType from a dii client using Parameter configuration.");

        BaseFooObject baseFoo = new BaseFooObject(new BigInteger("12345"), 04, true);
        int[] intArray = {1, 4, 7, 9, 11};
        IntArrayTest simpleArray = new IntArrayTest(intArray);

        ValueTypeWObjectMemberAObjectMemberArray param =
                new ValueTypeWObjectMemberAObjectMemberArray(
                        new java.util.GregorianCalendar(), new java.util.GregorianCalendar(), 129, baseFoo,
                        simpleArray, "fooString");

        ChangeComplexValueType changeComplexValueType = new ChangeComplexValueType(param);
        Object[] params = {changeComplexValueType};

        //  Invoke changeComplexType:
        ChangeComplexValueTypeResponse result1 = (ChangeComplexValueTypeResponse)
                call.invoke(params);

        ValueTypeWObjectMemberAObjectMemberArray result = result1.getResult();
        BaseFooObject rfoo = result.getMyValueType();
        System.out.println("\nRunning ComplexValueType from a dii client not using WSDL");
        System.out.println("Client output for testComplexValueType : " + rfoo.getFirst().toString());
        System.out.println("Client output for testComplexValueType : " + rfoo.getSecond());
        System.out.println("Client output for testComplexValueType : " + rfoo.isThird());

        System.out.println("\nOriginal unsigned long in ValueTypeWObjectMemberAObjectMemberArray : 129");
        System.out.println("Modified unsigned long in ValueTypeWObjectMemberAObjectMemberArray  : " + result.getLongUnsignedInt());

    }

    public void testSimpleIntArray()
    throws Exception
    {

        QName operation = new QName(BODY_NAMESPACE_VALUE, "reverseArray");

        Call call = service.createCall(port, operation);

        call.setTargetEndpointAddress(endpoint);

        call.setProperty(Call.SOAPACTION_USE_PROPERTY,
                new Boolean(true));
        call.setProperty(Call.SOAPACTION_URI_PROPERTY, "");
        call.setProperty(ENCODING_STYLE_PROPERTY, "");
        call.setProperty(Call.OPERATION_STYLE_PROPERTY, "document");

        QName REQUEST_QNAME = new QName(TYPE_NAMESPACE_VALUE, "reverseArray");

        call.addParameter("parameters", REQUEST_QNAME, hello.ReverseArray.class,
                ParameterMode.IN);

        QName RESPONSE_QNAME = new QName(TYPE_NAMESPACE_VALUE, "reverseArrayResponse");
        call.setReturnType(RESPONSE_QNAME, hello.ReverseArrayResponse.class);

        System.out.println("\nRunning int[] from a dii client using Parameter configuration");
        int[] intArray = {1, 4, 7, 9, 11};
        IntArrayTest param = new IntArrayTest(intArray);
        ReverseArray rArray = new ReverseArray(param);
        Object[] params = {rArray};

    // Invoke reverseArray:
        ReverseArrayResponse result1 = (ReverseArrayResponse) call.invoke(params);

        IntArrayTest result = result1.getResult();
        int[] rintArray = result.getIntArray();

        System.out.println("Client output for testSimpleIntArray   : " + java.util.Arrays.equals(intArray, rintArray));
    }
}
