/*
 * ClientHandler1.java
 */

package client;

import javax.xml.namespace.QName;
import javax.xml.rpc.handler.soap.SOAPMessageContext;
import javax.xml.rpc.JAXRPCException;

import javax.xml.rpc.handler.*;
import javax.xml.soap.*;

/**
 * This class implements a handler by extending the abstract
 * class javax.xml.rpc.handler.GenericHandler.
 */
public class ClientHandler1 extends GenericHandler {
    
    HandlerInfo handlerInfo;
    String name;

    public void init(HandlerInfo info) {
        handlerInfo = info;
        
        // this parameter was configured in config.xml
        name = (String) info.getHandlerConfig().get("name");
        System.out.println("ClientHandler1: name = " + name);
    }
    
    /*
     * This method is declared abstract in GenericHandler and must
     * be defined here. Another way to implement is to keep an array
     * of QNames and set them in the init() method to info.getHeaders().
     */
    public QName[] getHeaders() {
        return handlerInfo.getHeaders();
    }
    
    /*
     * 
     */
    public boolean handleRequest(MessageContext context) {
        try {

            // get the soap header
            SOAPMessageContext smc = (SOAPMessageContext) context;
            SOAPMessage message = smc.getMessage();
            SOAPPart soapPart = message.getSOAPPart();
            SOAPEnvelope envelope = soapPart.getEnvelope();
            SOAPHeader header = message.getSOAPHeader();
            if (header == null) {
                header = envelope.addHeader();
            }
            
            /* Add logger element with musUnderstand=1.
             * Will use the default actor "next" for this example, otherwise
             * use loggerElement.setActor(String actorURI).
             * The element will contain a ficticuous log level for
             * this example.
             */
            System.out.println("ClientHandler1: adding loggerElement");
            SOAPHeaderElement loggerElement =
                header.addHeaderElement(envelope.createName("loginfo",
                    "ns1", "http://example.com/headerprops"));
            loggerElement.setMustUnderstand(true);
            loggerElement.setValue("10");
            
            // Add simple element describing the client making the request.
            System.out.println("ClientHandler1: adding nameElement");
            SOAPHeaderElement nameElement =
                header.addHeaderElement(envelope.createName("clientname",
                    "ns1", "http://example.com/headerprops"));
            nameElement.addTextNode("Duke");
                    
        } catch (Exception e) {
            throw new JAXRPCException(e);
        }

        // return true to continue message processing
        return true;
    }
    
}
