/*
This file is licensed under the terms of the Globus Toolkit Public
License, found at http://www.globus.org/toolkit/download/license.html.
*/
package org.globus.progtutorial.clients.amazon;

import org.globus.progtutorial.stubs.AmazonSearchService.service.AmazonSearchServiceGridLocator;
import org.globus.progtutorial.stubs.AmazonSearchService.AmazonSearchPortType;
import java.util.Vector;

import java.net.URL;

public class AmazonSearchClient
{
	public static void main(String[] args)
	{
		try
		{
			// Get command-line arguments
			URL GSH = new java.net.URL(args[0]);

			// Get a reference to the MathService instance
			AmazonSearchServiceGridLocator amazonSearchServiceLocator = new AmazonSearchServiceGridLocator();
			AmazonSearchPortType amazonSearch = amazonSearchServiceLocator.getAmazonSearchServicePort(GSH);

			// Call remote method 'add'
			Vector results = amazonSearch.searchAuthor(args[1]);

			System.out.println("Titles published by this author: ");
			for (int counter = 0; counter < results.size(); counter++) {
				System.out.println((counter + 1) + ". " + results.elementAt(counter));
			}

		}catch(Exception e)
		{
			e.printStackTrace();
		}
	}
}
