package edu.buffalo.cse.jive.app.bst;

import java.util.NoSuchElementException;

public class BSTNode implements BST {

  private int data;
  private BSTNode left;
  private BSTNode right;

  public BSTNode(int data) {

    this.data = data;
    this.left = null;
    this.right = null;
  }

  @Override
  public int data() {

    return data;
  }

  @Override
  public void insert(int element) {

    if (data >= element) {
      if (left == null) {
        left = new BSTNode(element);
      }
      else {
        left.insert(element);
      }
    }
    else if (data < element) {
      if (right == null) {
        right = new BSTNode(element);
      }
      else {
        right.insert(element);
      }
    }
  }

  @Override
  public BSTNode left() {

    return left;
  }

  @Override
  public BSTNode remove(int n) {

    if (n < data) {
      if (left != null) {
        left = (BSTNode) left.remove(n);
      }
      else {
        throw new NoSuchElementException();
      }
    }
    else if (n > data) {
      if (right != null) {
        right = (BSTNode) right.remove(n);
      }
      else {
        throw new NoSuchElementException();
      }
    }
    else if (left != null && right != null) {
      BSTNode node = right.minimum();
      data = node.data;
      right = right.removeMinimum(); // replaces the right subtree with the right subtree of the
      // minimum node
      // right = right.remove(data);
    }
    else {
      return left != null ? left : right;
    }
    return this;
  }

  private BSTNode minimum() {

    if (left == null) {
      return this;
    }
    else {
      return left.minimum();
    }
  }

  private BSTNode removeMinimum() {

    if (left == null) {
      return right;
    }
    else {
      return left.removeMinimum();
    }
  }

  @Override
  public BSTNode right() {

    return right;
  }
}