package edu.buffalo.cse.jive.app.dblp.sql;

import java.io.IOException;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

import edu.buffalo.cse.jive.app.dblp.model.Entity;
import edu.buffalo.cse.jive.app.dblp.model.Entity.TypeEntity;
import edu.buffalo.cse.jive.app.dblp.model.Entity.TypeField;
import edu.buffalo.cse.jive.app.dblp.model.Entity.TypeTitleContents;

public class SQLGenerator extends DefaultHandler {

  private Entity entity = null;
  private TypeField fieldType = null;
  private String fieldValue = null;
  private final SQLPersister persister;

  public SQLGenerator(final SQLPersister persister) {

    this.persister = persister;
  }

  @Override
  public void characters(final char[] ch, final int start, final int length) throws SAXException {

    fieldValue += new String(ch, start, length);
  }

  private boolean checkEntityType(final String tagName) {

    boolean result = true;
    try {
      TypeEntity.valueOf(tagName.toLowerCase());
    }
    catch (final IllegalArgumentException e) {
      result = false;
    }
    return result;
  }

  private boolean checkFieldType(final String tagName) {

    boolean result = true;
    try {
      TypeField.valueOf(tagName.toLowerCase());
    }
    catch (final IllegalArgumentException e) {
      result = false;
    }
    return result;
  }

  private boolean checkTitleContentsType(final String tagName) {

    boolean result = true;
    try {
      TypeTitleContents.valueOf(tagName.toLowerCase());
    }
    catch (final IllegalArgumentException e) {
      result = false;
    }
    return result;
  }

  @Override
  public void endElement(final String uri, final String localName, final String qName)
      throws SAXException {

    if (fieldType == null && entity == null && "dblp".equalsIgnoreCase(localName)) {
      return;
    }
    // if this does not throw an exception, it is the end tag of the current entity
    if (entity != null && fieldType == null && checkEntityType(localName)) {
      try {
        persister.persist(entity);
      }
      catch (IOException e) {
        e.printStackTrace();
      }
      entity = null;
      return;
    }
    // otherwise, it is the end tag of the current field
    if (entity != null && fieldType != null && checkFieldType(localName)) {
      entity.updateProperty(fieldType, fieldValue);
      fieldType = null;
      fieldValue = "";
      return;
    }
    if (entity != null && fieldType != null && checkTitleContentsType(localName)) {
      fieldValue += "</" + localName.toLowerCase() + ">";
      return;
    }
    throw new SAXException(String.format("Unexpected end tag: %s", localName));
  }

  @Override
  public void startElement(final String uri, final String localName, final String name,
      final Attributes atts) throws SAXException {

    if (fieldType == null && entity == null && "dblp".equalsIgnoreCase(localName)) {
      return;
    }
    // if this does not throw an exception, it is the start tag of a new entity
    if (entity == null && fieldType == null && checkEntityType(localName)) {
      entity = new Entity(TypeEntity.valueOf(localName.toLowerCase()), atts);
      return;
    }
    // if this is the start tag of a new field
    if (entity != null && fieldType == null && checkFieldType(localName)) {
      fieldType = TypeField.valueOf(localName.toLowerCase());
      fieldValue = "";
      return;
    }
    if (entity != null && fieldType != null && checkTitleContentsType(localName)) {
      fieldValue += "<" + localName.toLowerCase() + ">";
      return;
    }
    throw new SAXException(String.format("Unexpected start tag: %s", localName));
  }
}