package edu.buffalo.cse.jive.app.linkedlist.driver;

import edu.buffalo.cse.jive.app.linkedlist.ListFactory;
import edu.buffalo.cse.jive.app.linkedlist.ListFactory.JiveList;

/**
 * JIVE Demo: driver for the LinkedList implementation of the generic list.
 */
public class LinkedListDriver extends ListDriver {

  private JiveList<Integer> intList;

  protected void show() {

    System.out.println(intList + ":" + intList.size());
  }

  protected void insert(int value) {

    intList.insert(value);
    if (traceOn) {
      show();
    }
  }

  protected void remove(int value) {

    intList.remove(value);
    if (traceOn) {
      show();
    }
  }

  protected void newList() {

    intList = ListFactory.createList();
  }

  public static void main(String args[]) {

    driver = new LinkedListDriver();
    driver.firstTest();
    // driver.secondTest();
  }
}