package edu.buffalo.cse.jive.app.sorting;

public enum AlgorithmId {
  BUBBLE_SORT("Bubble Sort") {

    @Override
    public <E extends Comparable<E>> SortAlgorithm<E> createAlgorithm(
        final SortAlgorithmFactory actualFactory, SortableCollection<E> values, boolean isAnimated) {

      return new BubbleSort<E>(values, actualFactory, isAnimated);
    }
  },
  INSERTION_SORT("Insertion Sort") {

    @Override
    public <E extends Comparable<E>> SortAlgorithm<E> createAlgorithm(
        final SortAlgorithmFactory actualFactory, SortableCollection<E> values, boolean isAnimated) {

      return new InsertionSort<E>(values, actualFactory, isAnimated);
    }
  },
  MERGE_SORT("Merge Sort") {

    @Override
    public <E extends Comparable<E>> SortAlgorithm<E> createAlgorithm(
        final SortAlgorithmFactory actualFactory, SortableCollection<E> values, boolean isAnimated) {

      return new MergeSort<E>(values, actualFactory, isAnimated);
    }
  },
  QUICK_SORT("Quick Sort") {

    @Override
    public <E extends Comparable<E>> SortAlgorithm<E> createAlgorithm(
        final SortAlgorithmFactory actualFactory, SortableCollection<E> values, boolean isAnimated) {

      return new QuickSort<E>(values, actualFactory, isAnimated);
    }
  },
  SELECTION_SORT("Selection Sort") {

    @Override
    public <E extends Comparable<E>> SortAlgorithm<E> createAlgorithm(
        final SortAlgorithmFactory actualFactory, SortableCollection<E> values, boolean isAnimated) {

      return new SelectionSort<E>(values, actualFactory, isAnimated);
    }
  };

  private final String algoName;

  private AlgorithmId(final String algoName) {

    this.algoName = algoName;
  }

  public String algoName() {

    return algoName;
  }

  @Override
  public String toString() {

    return algoName;
  }

  public abstract <E extends Comparable<E>> SortAlgorithm<E> createAlgorithm(
      final SortAlgorithmFactory actualFactory, final SortableCollection<E> values,
      final boolean isAnimated);
}