package edu.buffalo.cse.jive.benchmarks;

import java.io.File;

import edu.buffalo.cse.jive.app.bst.Controller;
import edu.buffalo.cse.jive.app.bst.Controller.ControllerException;

class BenchmarkBST extends Benchmark {

	private static final String BST_10 = "data/bst-10.txt";
	private static final String BST_50 = "data/bst-50.txt";
	private static final String BST_100 = "data/bst-100.txt";
	private static final String BST_500 = "data/bst-500.txt";
	private static final String BST_1000 = "data/bst-1000.txt";

	private static String BST;

	public static void main(final String[] args) throws BenchmarkException {

		BST = BST_10;
		BST = BST_50;
		BST = BST_100;
//		BST = BST_500;
//		BST = BST_1000;
		Benchmark.run(BenchmarkBST.class, 1);
	}

	@Override
	protected String name() {

		return "BST Application " + BST;
	}

	@Override
	public void doRun() throws BenchmarkException {

		final Controller c = new Controller(false);
		try {
			c.showView();
			c.loadModel(new File(getResource(BST)));
			c.waitForWorker();
			c.closeView();
		} catch (final ControllerException ce) {
			throw new BenchmarkException(ce);
		}
	}
}