package edu.buffalo.cse.jive.benchmarks;

import java.util.Iterator;

import edu.buffalo.cse.jive.benchmarks.Benchmark.BenchmarkException;
import etomica.graph.iterators.DefaultIterator;
import etomica.graph.model.Graph;

class BenchmarkGraphsDefault extends Benchmark {

  private static final byte NODE_COUNT_3 = 3;
  private static final byte NODE_COUNT_4 = 4;
  private static final byte NODE_COUNT_5 = 5;
  private static final byte NODE_COUNT_6 = 6;
  private static final byte NODE_COUNT_7 = 7;

  private static byte NODE_COUNT;

  public static void main(final String[] args) throws BenchmarkException {

    NODE_COUNT = NODE_COUNT_5;
    Benchmark.run(BenchmarkGraphsDefault.class, 1);
  }

  @Override
  protected String name() {

    return "Graph Set Generation-" + NODE_COUNT;
  }

  @Override
  protected void doRun() throws BenchmarkException {

    int enumerated = 0;
    final boolean printPermutations = false;
    final int expected = NODE_COUNT == 0 ? 0 : 1 << (NODE_COUNT) * (NODE_COUNT - 1) / 2;
    final Iterator<Graph> iterator = new DefaultIterator(NODE_COUNT);
    while (iterator.hasNext()) {
      enumerated++;
      if (printPermutations) {
        message(iterator.next().toString());
      }
      else {
        iterator.next();
      }
    }
    if (enumerated != expected) {
      message("Expected %d graphs with %d nodes, but enumerated %d graphs.", expected, NODE_COUNT,
          enumerated);
    }
    // else {
    // message("%d graphs with %d nodes enumerated.", expected, NODE_COUNT);
    // }
  }
}
