package edu.buffalo.cse.jive.data;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class DataFactoryTest {

  private static final boolean PRINT_LIST = true;

  private static void checkEquals(final List<? extends Number> first,
      final List<? extends Number> second) {

    if (first.size() != second.size()) {
      System.err.println("Lists are not identical: sizes are different.");
    }
    for (int i = 0; i < first.size(); i++) {
      if (!first.get(i).equals(second.get(i))) {
        System.err.println("Lists are not identical: elements differ at position " + i + ".");
        return;
      }
    }
  }

  public static void main(final String[] args) throws IOException {

    // printList(DataFactory.normalDoubleList(50));
    // printList(DataFactory.normalDoubleList(50));
    // printList(DataFactory.normalDoubleList(50));
    //
    // printList(DataFactory.normalDoubleList(50, 100, 10));
    // printList(DataFactory.normalDoubleList(500, 100, 10));
    // printList(DataFactory.normalDoubleList(5000, 100, 10));
    //
    // printList(DataFactory.normalDoubleList(50, 500, 10));
    // printList(DataFactory.normalDoubleList(500, 500, 10));
    // printList(DataFactory.normalDoubleList(5000, 500, 10));
    //
    // printList(DataFactory.normalDoubleList(50, 1000, 10));
    // printList(DataFactory.normalDoubleList(500, 1000, 10));
    // printList(DataFactory.normalDoubleList(5000, 1000, 10));
    //
    // printList(DataFactory.normalIntegerList(50, 100, 10));
    // printList(DataFactory.normalIntegerList(500, 100, 10));
    // printList(DataFactory.normalIntegerList(5000, 100, 10));
    //
    // printList(DataFactory.normalIntegerList(50, 500, 10));
    // printList(DataFactory.normalIntegerList(500, 500, 10));
    // printList(DataFactory.normalIntegerList(5000, 500, 10));
    //
    // printList(DataFactory.normalIntegerList(50, 1000, 10));
    // printList(DataFactory.normalIntegerList(500, 1000, 10));
    // printList(DataFactory.normalIntegerList(5000, 1000, 10));
    //
    // final List<Double> saved1d = DataFactory.normalDoubleList(50, 1000, 10);
    // final List<Double> saved2d = DataFactory.normalDoubleList(500, 1000, 10);
    // final List<Double> saved3d = DataFactory.normalDoubleList(5000, 1000, 10);
    //
    // DataFactory.saveAsDoubleList(saved1d, "/home/demian/Public/list1d.txt");
    // DataFactory.saveAsDoubleList(saved2d, "/home/demian/Public/list2d.txt");
    // DataFactory.saveAsDoubleList(saved3d, "/home/demian/Public/list3d.txt");
    //
    // DataFactory.saveAsIntegerList(saved1d, "/home/demian/Public/list1di.txt");
    // DataFactory.saveAsIntegerList(saved2d, "/home/demian/Public/list2di.txt");
    // DataFactory.saveAsIntegerList(saved3d, "/home/demian/Public/list3di.txt");
    //
    // final List<Double> loaded1d = DataFactory.loadAsDoubleList("/home/demian/Public/list1d.txt");
    // final List<Double> loaded2d = DataFactory.loadAsDoubleList("/home/demian/Public/list2d.txt");
    // final List<Double> loaded3d = DataFactory.loadAsDoubleList("/home/demian/Public/list3d.txt");
    //
    // checkEquals(saved1d, loaded1d);
    // checkEquals(saved2d, loaded2d);
    // checkEquals(saved3d, loaded3d);
    //
    // final List<Integer> saved1i = DataFactory.normalIntegerList(50, 2000, 10);
    // final List<Integer> saved2i = DataFactory.normalIntegerList(500, 2000, 10);
    // final List<Integer> saved3i = DataFactory.normalIntegerList(5000, 2000, 10);
    //
    // DataFactory.saveAsIntegerList(saved1i, "/home/demian/Public/list1i.txt");
    // DataFactory.saveAsIntegerList(saved2i, "/home/demian/Public/list2i.txt");
    // DataFactory.saveAsIntegerList(saved3i, "/home/demian/Public/list3i.txt");
    //
    // DataFactory.saveAsDoubleList(saved1i, "/home/demian/Public/list1id.txt");
    // DataFactory.saveAsDoubleList(saved2i, "/home/demian/Public/list2id.txt");
    // DataFactory.saveAsDoubleList(saved3i, "/home/demian/Public/list3id.txt");
    //
    // final List<Integer> loaded1i =
    // DataFactory.loadAsIntegerList("/home/demian/Public/list1i.txt");
    // final List<Integer> loaded2i =
    // DataFactory.loadAsIntegerList("/home/demian/Public/list2i.txt");
    // final List<Integer> loaded3i =
    // DataFactory.loadAsIntegerList("/home/demian/Public/list3i.txt");
    //
    // checkEquals(saved1i, loaded1i);
    // checkEquals(saved2i, loaded2i);
    // checkEquals(saved3i, loaded3i);
    //
    // /*
    // * whether you load or save as integer, you should get the same lists back
    // */
    // printList(DataFactory.loadAsIntegerList("/home/demian/Public/list1d.txt"));
    // printList(DataFactory.loadAsIntegerList("/home/demian/Public/list1di.txt"));
    // printList(DataFactory.loadAsIntegerList("/home/demian/Public/list2d.txt"));
    // printList(DataFactory.loadAsIntegerList("/home/demian/Public/list2di.txt"));
    // printList(DataFactory.loadAsIntegerList("/home/demian/Public/list3d.txt"));
    // printList(DataFactory.loadAsIntegerList("/home/demian/Public/list3di.txt"));
    //
    // /*
    // * whether you load or save as integer, you should get the same lists back
    // */
    // printList(DataFactory.loadAsIntegerList("/home/demian/Public/list1i.txt"));
    // printList(DataFactory.loadAsIntegerList("/home/demian/Public/list1id.txt"));
    // printList(DataFactory.loadAsIntegerList("/home/demian/Public/list2i.txt"));
    // printList(DataFactory.loadAsIntegerList("/home/demian/Public/list2id.txt"));
    // printList(DataFactory.loadAsIntegerList("/home/demian/Public/list3i.txt"));
    // printList(DataFactory.loadAsIntegerList("/home/demian/Public/list3id.txt"));
    //
    // /*
    // * whether you load or save as double, you should get the same lists back
    // */
    // printList(DataFactory.loadAsDoubleList("/home/demian/Public/list1i.txt"));
    // printList(DataFactory.loadAsDoubleList("/home/demian/Public/list1id.txt"));
    // printList(DataFactory.loadAsDoubleList("/home/demian/Public/list2i.txt"));
    // printList(DataFactory.loadAsDoubleList("/home/demian/Public/list2id.txt"));
    // printList(DataFactory.loadAsDoubleList("/home/demian/Public/list3i.txt"));
    // printList(DataFactory.loadAsDoubleList("/home/demian/Public/list3id.txt"));

    int fileSize = 10;
    List<Integer> bst, bstUnique;
    do {
      DataFactory.saveAsIntegerList(DataFactory.createIntegerSet(fileSize, 1, 5000),
          "/home/demian/bst-" + fileSize + ".txt");
      bst = DataFactory.loadAsIntegerList("/home/demian/bst-" + fileSize + ".txt");
      bstUnique = new ArrayList<Integer>(new HashSet<Integer>(bst));
    }
    while (bst.size() != bstUnique.size());
    printList(bstUnique);

    // DataFactory.saveAsIntegerList(DataFactory.createIntegerList(10, 1, 200),
    // "/home/demian/bst-10.txt");
    // final List<Integer> bst10 = DataFactory.loadAsIntegerList("/home/demian/bsta-10.txt");
    // printList(bst10);
    // final List<Integer> bstUniqueList10 = new ArrayList<Integer>(new HashSet<Integer>(bst10));
    // printList(bstUniqueList10);

    // DataFactory.saveAsIntegerList(DataFactory.createIntegerList(20, 1, 200),
    // "/home/demian/bst-20.txt");
    // final List<Integer> bst20 = DataFactory.loadAsIntegerList("/home/demian/bsta-20.txt");
    // printList(bst20);
    // final List<Integer> bstUniqueList20 = new ArrayList<Integer>(new HashSet<Integer>(bst20));
    // printList(bstUniqueList20);

    // DataFactory.saveAsIntegerList(DataFactory.createIntegerList(30, 1, 200),
    // "/home/demian/bst-30.txt");
    // final List<Integer> bst30 = DataFactory.loadAsIntegerList("/home/demian/bsta-30.txt");
    // printList(bst30);
    // final List<Integer> bstUniqueList30 = new ArrayList<Integer>(new HashSet<Integer>(bst30));
    // printList(bstUniqueList30);

    // DataFactory.saveAsIntegerList(DataFactory.createIntegerList(40, 1, 200),
    // "/home/demian/bst-40.txt");
    // final List<Integer> bst40 = DataFactory.loadAsIntegerList("/home/demian/bsta-40.txt");
    // printList(bst40);
    // final List<Integer> bstUniqueList40 = new ArrayList<Integer>(new HashSet<Integer>(bst40));
    // printList(bstUniqueList40);

    // DataFactory.saveAsIntegerList(DataFactory.createIntegerList(50, 1, 200),
    // "/home/demian/bst-50.txt");
    // final List<Integer> bst50 = DataFactory.loadAsIntegerList("/home/demian/bsta-50.txt");
    // printList(bst50);
    // final List<Integer> bstUniqueList50 = new ArrayList<Integer>(new HashSet<Integer>(bst50));
    // printList(bstUniqueList50);
  }

  private static double mean(final List<? extends Number> values) {

    double result = 0;
    for (final Number n : values) {
      result += n.doubleValue();
    }
    return result / values.size();
  }

  private static void printList(final List<? extends Number> list) {

    if (PRINT_LIST) {
      System.out.println("List: " + list.toString());
    }
    final double mean = mean(list);
    System.out
        .format("size: %d; mean: %5.2f; stdev: %5.3f\n", list.size(), mean, stdev(mean, list));
  }

  private static double stdev(final double mean, final List<? extends Number> values) {

    double result = 0;
    for (final Number n : values) {
      result += (mean - n.doubleValue()) * (mean - n.doubleValue());
    }
    return StrictMath.sqrt(result / (values.size() - 1));
  }
}