import java.util.LinkedList;
import java.util.List;

public class ListDriver {

	private final List<MyItem> myList;

	ListDriver() {

		myList = new LinkedList<MyItem>();
    populateList();
	}

	public static void main(String[] args) {

		final ListDriver driver = new ListDriver();
		driver.printList();
	}

	private void prePopulateList() {

		populateList();
	}

	private void populateList() {

		myList.add(new MyItem("roses are red"));
		myList.add(new MyItem("violets are blue"));
		myList.add(new MyItem("dogs bark"));
		myList.add(new MyItem("cows moo"));
	}

	private void printList() {

		System.out.println(myList);
	}
}

class MyItem {

	private String secret;

	MyItem(final String secret) {
		this.secret = secret;
	}

	@Override
	public String toString() {
		return String.format("This is my secret: '%s'", secret);
	}

}
