package edu.buffalo.cse.jive.app.bst;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;

import edu.buffalo.cse.jive.app.bst.Controller;
import edu.buffalo.cse.jive.app.bst.Controller.ControllerException;
import edu.buffalo.cse.jive.benchmarks.Benchmark;

class Driver {

	private static final String BST_10 = "data/bst-10.txt";

	// private static final String BST_50 = "data/bst-50.txt";
	// private static final String BST_100 = "data/bst-100.txt";
	// private static final String BST_500 = "data/bst-500.txt";
	// private static final String BST_1000 = "data/bst-1000.txt";

	protected static URI getResource(final String resourcePath)
			throws URISyntaxException {

		return Benchmark.class.getResource(resourcePath).toURI();
	}

	public static void main(final String[] args) throws URISyntaxException,
			ControllerException {

		final Controller c = new Controller(false);
		c.showView();
		c.loadModel(new File(getResource(BST_10)));
		c.waitForWorker();
		c.closeView();
	}
}