package edu.buffalo.cse.jive.app.bst;

import java.io.File;
import java.lang.reflect.InvocationTargetException;

import javax.swing.SwingUtilities;

import edu.buffalo.cse.jive.app.bst.animation.TreeGUI;

public class View {

	private final Controller controller;
	private final TreeGUI gui;
	private final UpdateUIJob updateJob;

	public View(final Controller controller) {

		this.controller = controller;
		this.updateJob = new UpdateUIJob();
		this.gui = new TreeGUI(View.this);
	}

	public void close() throws InterruptedException, InvocationTargetException {

		SwingUtilities.invokeAndWait(new Runnable() {

			@Override
			public void run() {

				gui.dispose();
			}
		});
	}

	public void show() throws InterruptedException, InvocationTargetException {

		gui.pack();
		gui.setVisible(true);
		SwingUtilities.invokeAndWait(new StartUIJob());
	}

	public boolean done() {

		return gui.done();
	}

	private final class UpdateUIJob implements Runnable {

		@Override
		public void run() {

			gui.update();
		}
	}

	private final class StartUIJob implements Runnable {

		@Override
		public void run() {

			gui.pack();
			gui.setVisible(true);
		}
	}

	public void updateUI() {

		SwingUtilities.invokeLater(updateJob);
	}

	public void loadModel(final File file) {

		controller.loadModel(file);
	}

	public Model getModel() {

		return controller.getModel();
	}
}