package edu.buffalo.cse.jive.app.dblp.sampler;

import java.io.IOException;
import java.io.Writer;

import edu.buffalo.cse.jive.app.dblp.model.Persister;

public class XMLPersister implements Persister {

  public int entityCounter = 0;
  private final Writer handleXML;

  XMLPersister(final XMLWriterFactory factory, final String fileName) throws IOException {

    handleXML = factory.newWriter(fileName);
  }

  @Override
  public int entityCounter() {

    return entityCounter;
  }

  @Override
  public void flush() throws IOException {

    handleXML.write("</dblp>");
    handleXML.flush();
  }

  @Override
  public void prepare() throws IOException {

    handleXML.write("<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>\n");
    handleXML.write("<!DOCTYPE dblp SYSTEM \"dblp.dtd\">\n");
    handleXML.write("<dblp>\n");
  }

  @Override
  public void persist(final Object source) throws IOException {

    final String entity = (String) source;
    entityCounter++;
    handleXML.write(entity);
    handleXML.flush();
  }
}