package edu.buffalo.cse.jive.app.dblp.sql;

import java.io.IOException;

import edu.buffalo.cse.jive.app.dblp.model.WriterFactory;

public class SQLWriterFactory extends WriterFactory {

  private final String folderName;
  private SQLPersister persister;
  private final boolean protectInTransaction;

  public SQLWriterFactory(final String folderName, final boolean protectInTransaction) {

    this.folderName = folderName;
    this.protectInTransaction = protectInTransaction;
  }

  @Override
  public SQLPersister defaultPersister() throws IOException {

    if (persister == null) {
      persister = new SQLPersister(folderName, this, protectInTransaction);
    }
    return persister;
  }
}