package edu.buffalo.cse.jive.app.sorting;


final class QuickSort<T extends Comparable<T>> extends SortAlgorithm<T> {

  QuickSort(final SortableCollection<T> values, final SortAlgorithmFactory factory,
      final boolean isAnimated) {

    super(AlgorithmId.QUICK_SORT, values, factory, isAnimated);
  }

  private void quickSort(final int first, final int last) {

    // 0 or 1 elements: collection is sorted
    if (first >= last) {
      return;
    }
    // 2 elements: might need to swap items
    else if (first == last - 1) {
      if (compare(first, last) > 0) {
        swap(first, last);
      }
      return;
    }
    else {
      int i = first; // index of left-to-right scan
      int k = last; // index of right-to-left scan
      final int pivot = first; // arbitrarily set the pivot
      while (k > i) { // while the scan indices from left and right
        // have not crossed...
        // from the left, look for the first element greater than
        // the pivot (avoids
        // problem with pivot == first)
        while (i < k && i <= last && compare(i, pivot) <= 0) {
          i++;
        }
        // from the right, look for the first element not greater
        // than the pivot
        while (i <= k && k >= first & compare(k, pivot) > 0) {
          k--;
        }
        // if the left index is still smaller than the right index,
        // swap the
        // corresponding elements
        if (k > i) {
          swap(i, k);
        }
      }
      // indices have crossed: swap the last element in the left
      // partition with the pivot
      swap(first, k);
      quickSort(first, k - 1); // sort the left partition
      quickSort(k + 1, last); // sort the right partition
    }
  }

  @Override
  protected void sort() {

    try {
      quickSort(0, getData().size() - 1);
    }
    catch (final Exception e) {
    }
  }
}