package edu.buffalo.cse.jive.app.sorting;


final class SelectionSort<T extends Comparable<T>> extends SortAlgorithm<T> {

  SelectionSort(final SortableCollection<T> values, final SortAlgorithmFactory factory,
      final boolean isAnimated) {

    super(AlgorithmId.SELECTION_SORT, values, factory, isAnimated);
  }

  @Override
  protected void sort() {

    final int size = getData().size();
    for (int i = 0; i < size; i++) {
      int min = i;
      int j;
      /* * Find the smallest element in the unsorted list */
      for (j = i + 1; j < size; j++) {
        if (compare(j, min) < 0) {
          min = j;
        }
      }
      /*
       * * Swap the smallest unsorted element into the end of the * sorted list.
       */
      swap(min, i);
    }
  }
}