package edu.buffalo.cse.jive.benchmarks;

import edu.buffalo.cse.jive.app.dblp.model.Processor;

class BenchmarkDBLP extends Benchmark {

  private static final String FILE_NAME = "dblp";
  private static final String XML_FOLDER_NAME = "data/";
  private static final String SQL_FOLDER_NAME = "C:\\Users\\demian\\Documents\\dblp\\";

  private static int SAMPLE_ID;

  public static void main(final String[] args) throws BenchmarkException {

    SAMPLE_ID = 0;
    SAMPLE_ID = 1;
    SAMPLE_ID = 2;
    SAMPLE_ID = 3;
    SAMPLE_ID = 4;
    Benchmark.run(BenchmarkDBLP.class, 1);
  }

  @Override
  protected String name() {

    return "DBLP XML Processing dblp-" + Processor.SAMPLE_IDS[SAMPLE_ID];
  }

  @Override
  public void doRun() throws BenchmarkException {

    final Processor processor = new Processor(true, getResource(XML_FOLDER_NAME).getPath(),
        FILE_NAME, SQL_FOLDER_NAME);
    try {
      processor.sqlProcessSample(SAMPLE_ID);
    }
    catch (final Exception e) {
      throw new BenchmarkException(e);
    }
  }
}