#include <stdio.h>
#include <signal.h>
#include <errno.h>
#include <time.h>
#include <stdlib.h>
#include <math.h>
#include <wait.h>
#include <unistd.h>
#include <sys/types.h>

#define PSIG 43
#define CSIG 42

int ccount = 0;
int pcount = 0;
char str[] = "error message";

void psigfunc(int s)
{
  pcount++;
  printf("Parent hit! signal =  %d\n", s);
  signal(CSIG, psigfunc); //rearm signal
}

void csigfunc(int s)
{
  ccount++;
  printf("Child hit! signal =  %d\n", s);

  signal(PSIG, csigfunc); //rearm signal
}

main() {

  int ppid, cpid;
  ppid = getpid();
  cpid = fork();

  if (cpid == -1) {
    printf("failed to fork \n");
    exit(1);
  }

  /* child process executes here */
  if (cpid == 0){
  signal(PSIG, csigfunc);
  printf(" Child started \n");
  while(1)
    { 
      //          pause();
    printf("Child hit! count =  %d\n", ccount);
    sleep(rand()%10);
    if ((kill(ppid,CSIG))) perror(str);
    }
  }
  else
    /* parent process*/
    {
      signal(CSIG, psigfunc);
      printf("Parent started \n");
      while(1)
	{
	 sleep(rand()%10);
          if ((kill(cpid, PSIG)))perror (str);
	  //  pause();
          printf("Parent hit! count = %d\n",pcount);
	}
    }
}

