function print_top_words_1(filename, voc, sample, topword)

idx = find(sample.sum_mu > 0);
phi = sample.mu(idx, :)';
fid = fopen(filename, 'w');
fprintf(fid, 'topics for the %s model:\n', sample.model);
fprintf(fid, '#topics in total: %d\n\n', length(sample.sum_mu));
for i = 1:size(phi, 2)
    fprintf(fid, '------------Top words for topic %d (%d words in total)...-----------\n', i, sample.sum_mu(idx(i)));
    [a,IX] = sort(phi(:, i), 'descend');
    for j = 1:topword
        %fprintf(fid, '%s(%f) ', voc{IX(j)}, a(j));
		fprintf(fid, '%s ', voc{IX(j)});
    end
    fprintf(fid, '\n');
end
fclose(fid);

return
