%%%%%% C implementation for z, t %%%%%%%%%%%%%

function [samples, lik_tr, lik_te, elapse, elapse_tot] = sampler_wSNGG(data, M, q, burnin, every, ...
    numbofits, initK, v, h, dolik, a, tag_tr, output, log_file, model)

elapse = 1;

mu0 = h;
[nDP, nS] = size(q);

if length(M) ~= nS
	M = M(1) * ones(1, nS);
end

n_t = zeros(1, nDP);
n_t_tot = zeros(1, nDP);
for i = 1:nDP
	if tag_tr(i) == 1
    	n_t(i) = length(data{i});
    	n_t_tot(i) = length(data{i});
	else
		n_t_tot(i) = length(data{i});
		n_t(i) = ceil(n_t_tot(i) / 2);
	end
end

if length(initK) ~= nS
	initK = initK(1) * ones(1, nS);
end

% Set up for calculating predictive or not
s = cell(1, nDP);
cumK = zeros(1, nS + 1);
cumK(2:nS+1) = cumsum(initK);
K_id = zeros(1, sum(initK));
for i = 1:nS
	K_id(cumK(i)+1:cumK(i+1)) = i;
end

if isempty(find(q == 0))
    for i = 1:nDP
        s{i} = ceil(rand(1, n_t(i)) * sum(initK));
    end
else
    for i = 1:nDP
    	kk = initK .* double(q(i, :) > 0);
    	f = 1;
    	k1 = [];
    	for j = 1:length(kk)
    		if kk(j) > 0
    			k1(f:f+kk(j)-1) = cumK(j)+1:cumK(j+1);
    			f = f + kk(j);
    		end
    	end
        s{i} = k1(ceil(rand(1, n_t(i)) * (f - 1)));
        assert(min(s{i}) > 0 && max(s{i}) <= sum(initK));
    end
end
kstar = initK;

% Set jump sizes and parameters of components
mu = zeros(sum(kstar) + 1, v);
for j = 1:nDP
    for i = 1:n_t(j)
        mu(s{j}(i), data{j}(i)) = mu(s{j}(i), data{j}(i)) + 1;
    end
end
sum_mu = sum(mu, 2)';

nj = sum_mu;
n = zeros(1, nS);
n_ts = zeros(nDP, nS);
for k = 1:length(nj)-1
	n(K_id(k)) = n(K_id(k)) + nj(k);
end
nj_t = zeros(nDP, length(nj));
K_c = zeros(1, nDP+1);
K_ct = zeros(1, nS);
for i = 1:nDP
	for j = 1:length(nj)-1
		nj_t(i, j) = length(find(s{i} == j));
		n_ts(i, K_id(j)) = n_ts(i, K_id(j)) + nj_t(i, j);
		if nj_t(i, j) > 0
			K_c(i) = K_c(i) + 1;
		end
	end
end
K_c(nDP + 1) = length(nj) - 1;
for k = 1:length(nj)-1
	if nj(k) > 0
		K_ct(K_id(k)) = K_ct(K_id(k)) + 1;
	end
end

K_id = K_id - 1;
K_id = [K_id -1];

%load u1.mat;

tic
if strcmp(model, 'MNGG') == 1
    [samples, lik_tr, lik_te] = sample_zt_MNGG(mu, sum_mu, s, M, q, n, n_t, ...
        n_ts, nj, nj_t, K_c, K_ct, K_id, mu0, burnin, numbofits, every, dolik, ...
        data, a, gamma(1 - a), n_t_tot, tag_tr, output, log_file);
elseif strcmp(model, 'TNGG_marg2') == 1
    [samples, lik_tr, lik_te, elapse] = sample_zt_TNGG_marg2(mu, sum_mu, s, M, q, n, n_t, ...
        n_ts, nj, nj_t, K_c, K_ct, K_id, mu0, burnin, numbofits, every, dolik, ...
        data, a, gamma(1 - a), n_t_tot, tag_tr, output, log_file);
end

elapse_tot = toc;

for i = 1:length(samples)
	samples(i).gamma = h;
	samples(i).V = v;
    samples(i).model = model;
end
