/*
 * util.h
 *
 */

#ifndef UTIL_H_
#define UTIL_H_

#include <gsl/gsl_vector.h>
#include <gsl/gsl_matrix.h>
#include <gsl/gsl_rng.h>
#include <math.h>
#include <scythestat/matrix.h>

#define MAX_ITE_RAN 5

#ifdef _MSC_VER
#define finite _finite
#define isnan _isnan
#endif

#ifdef	 __USE_ISOC99
/* INFINITY and NAN are defined by the ISO C99 standard */
#else
double my_infinity(void) {
  double zero = 0;
  return 1.0/zero;
}
double my_nan(void) {
  double zero = 0;
  return zero/zero;
}
#define INFINITY my_infinity()
#define NAN my_nan()
#endif

typedef struct pair{
    int key;
    double value;
} pair;

double maxx(double a, double b);

/*
 * vector operations
 */
double vget(const gsl_vector*, int);
void vset(gsl_vector*, int, double);
void vinc(gsl_vector*, int, double);
void vprint(gsl_vector*);
void scanf_vector(char*, gsl_vector*);
void save_vector(char*, gsl_vector*);
double vsum(gsl_vector*);
void normalize(gsl_vector* v);

int veq(const gsl_vector*, const gsl_vector*);
int v_contain(const gsl_vector* v, double);
int v_non_zero(const gsl_vector* v);
/*
 * matrix operations
 */
double mget(const gsl_matrix* m, int, int);
void mset(gsl_matrix*, int, int, double);
void minc(gsl_matrix*, int, int, double);
void col_sum(gsl_matrix*, gsl_vector*);
void row_sum(gsl_matrix*, gsl_vector*);
double msum( gsl_matrix*);

void minverse(gsl_matrix *src, gsl_matrix *inv);
void mm_mult(gsl_matrix *m1, gsl_matrix *m2, gsl_matrix *result);
void mv_mult(gsl_matrix *m1, gsl_vector *m2, gsl_vector *result);

void mprint(gsl_matrix*);
void scanf_matrix(char*, gsl_matrix*);
void save_matrix(char*, gsl_matrix* m);
void printf_matrix(char*, gsl_matrix*);

/*
 * sampling operations
 */
void initial_rng();
void free_rng();
double next_uniform();
double exp_rand(double mu);
double norm_rand(double mu, double sigma);
int next_discrete_unnormalised(gsl_vector*, double);
int next_discrete_normalised(double*, int);
double max_val(double*, int);

double PG_rand(double z);
double PG_m(int b, double z);

void sort(gsl_vector*);
void sort1(gsl_vector*, gsl_vector*);
double safe_log(double);
double log_sum(double, double);
/*
 * stirling number generation
 */
void make_stirling_table(int maxN, int maxM, double* a, int I);
void update_stirling_table(double* a, int I);
void make_stirling_table_I(int maxN, int maxM, double a, int i);
double stirling(int n, int m, double a, int i);
void free_stirling_table(int I);
/*
 * Pochhammer Symbal
 */
double poch_sym(double, double, int);
double log_poch_sym(double, double, int);

double randgamma(double rr);

double GIGRND(double pp, double a, double b);

double trun_Gamma(gsl_rng *gen, double a, double b, double lower, double upper, double initx);
double rtgamma_rate(double shape, double rate, double right_t);

void rmvnrnd(gsl_rng *gen, scythe::Matrix<> &mu, scythe::Matrix<> &sigma, int N,
		scythe::Matrix<> &A, scythe::Matrix<> &b, scythe::Matrix<> &samples, int burnin);

int rmvnorm(const gsl_rng *r, const int n, const gsl_vector *mean, const gsl_matrix *var, gsl_vector *result);
int rmvnorm_1(const gsl_rng *r, const int n, scythe::Matrix<> &mean, scythe::Matrix<> &var,
		gsl_vector * res1, gsl_matrix *work, double *result);
double dmvnorm(const int n, const gsl_vector *x, const gsl_vector *mean, const gsl_matrix *var);
int rmvt(const gsl_rng *r, const int n, const gsl_vector *location, const gsl_matrix *scale, const int dof, gsl_vector *result);
double dmvt(const int n, const gsl_vector *x, const gsl_vector *location, const gsl_matrix *scale, const int dof);
int rwishart(const gsl_rng *r, const int n, const int dof, const gsl_matrix *scale, gsl_matrix *result);

//void Ellip_slice(gsl_vector *f, double (*loglik)(gsl_vector *x), const gsl_vector *mean, const gsl_matrix *var);
void Ellip_slice(gsl_vector *f, const gsl_vector *mean, const gsl_matrix *var);

#endif /* UTIL_H_ */
