/*
 * model.c
 *
 */
#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <gsl/gsl_sf.h>
#include <gsl/gsl_math.h>
#include <unistd.h>

#include "model.h"
#include "util.h"

extern int nclass;

Assignment* ass_tmp;

/*
 * k:	number of topics
 * v: 	size of vocabulary
 */
Model* new_model(int v, int K, double c, int C, double ell, double L, double nu)
{
	Model* model = (Model*) malloc(sizeof(Model));
	model->v = v;
	model->K = K;
	model->c = c;
	model->C = C;
	model->ell = ell;//10;
	model->L = L;
	model->maxL = L;
	model->nu = nu;

	model->eta = (double**)malloc(sizeof(double*) * model->maxL);
	for(int i = 0; i < model->maxL; i++){
		if(i < model->L){
			model->eta[i] = (double*)calloc(model->K + 1, sizeof(double));
		}else{
			model->eta[i] = NULL;
		}
	}
	//model->eta_sum = (double*)calloc(model->K + 1, sizeof(double));
	model->eta_aux = (double**)calloc(model->C, sizeof(double*));
	for(int i = 0; i < model->C; i++){
		model->eta_aux[i] = (double*)calloc(model->K + 1, sizeof(double));
	}
	model->eta_z = (double**)malloc(sizeof(double*) * model->maxL);
	for(int i = 0; i < model->maxL; i++){
		model->eta_z[i] = NULL; // haven't allocated memory here
	}
	model->eta_z_aux = (double**)malloc(sizeof(double*) * model->C);
	for(int i = 0; i < model->C; i++){
		model->eta_z_aux[i] = NULL; // haven't allocated memory here
	}

	return model;
}
/*
 * Initialize all count tables for statistics
 *
 */
Cts* new_cts(int K, int v, Corpus* c)
{
	int j;

	Cts* cts = (Cts*) malloc(sizeof(Cts));

	cts->n = new Matrix<>(K + 1, c->ndocs, true, 0);
	cts->lambda = (double*)calloc(c->ndocs, sizeof(double));
	cts->yd = (int*)calloc(c->ndocs, sizeof(int));
	cts->Cy = NULL; // not allocate memory here
	cts->N = (int*)calloc(c->ndocs, sizeof(int));
	cts->m = (int**)malloc(K * sizeof(int*));
	cts->M = (int*)calloc(K, sizeof(int));
	for(j = 0; j < K; ++j){
		cts->m[j] = (int*)calloc(v, sizeof(int));
	}
	return cts;
}

/*
 * Initialize the topic assignment of each word-token
 *
 */
Assignment* new_assignment(Corpus* c)
{
	int j;

	Assignment* ass = (Assignment*) malloc(sizeof(Assignment));
	ass->topic_ass = (int**) malloc(sizeof(int*) * c->ndocs);
	for (j = 0; j < c->ndocs; j++){
		ass->topic_ass[j] = (int*)malloc(sizeof(int) * c->docs[j].total);
	}
	ass_tmp = ass;
	return ass;
}

/*
 * randomly initialize the model
 *
 * Note: alpha and gamma are symmetrically initialized
 *
 */
Model* random_init(int K, int v, double c, int C, double ell,
		double L, double nu, double alpha, double gamma)
{
	Model* model;
	model = new_model(v, K, c, C, ell, L, nu);
	model->alpha = alpha;
	model->gamma = gamma;

	return model;
}

/*
 * read model
 *
 */
Model* read_model(char* file)
{
/*	char str[BUFSIZ];
	FILE* fileptr;
	Model* model;
	int v, K, tmp;
	double alp, gamma, c;

	sprintf(str, "%s/model_other.txt", file);
	fileptr = fopen(str, "r");
	if (!fileptr){
		printf("File %s/model_other.txt does not exist\n", file);
		exit(0);
	}

	tmp = fscanf(fileptr, "model->v: %d\n", &v);
	assert(tmp == 1);
	tmp = fscanf(fileptr, "model->K: %d\n", &K);
	assert(tmp == 1);
	tmp = fscanf(fileptr, "model->alpha: %lf\n", &alp);
	assert(tmp == 1);
	tmp = fscanf(fileptr, "model->gamma: %lf\n", &gamma);
	assert(tmp == 1);
	tmp = fscanf(fileptr, "model->c: %lf\n", &c);
	assert(tmp == 1);
	tmp = fscanf(fileptr, "\n");
	model = random_init(K, v, c, alp, gamma);

	sprintf(str, "%s/model_phi.txt", file);
	scanf_matrix(str, model->phi);

	sprintf(str, "%s/model_eta.txt", file);
	model->eta = new Matrix<>(str);

	return model;*/
	return NULL;
}
/*
 * function: to save model
 */
void save_model(Model* model, Cts *cts, int D, char* file)
{
	char str[BUFSIZ];
	FILE* fileptr;

	sprintf(str, "%s/model_other.txt", file);
	fileptr = fopen(str, "w");
	fprintf(fileptr, "model->v: %d\n", model->v);
	fprintf(fileptr, "model->K: %d\n", model->K);
	fprintf(fileptr, "model->alpha: %lf\n", model->alpha);
	fprintf(fileptr, "model->gamma: %lf\n", model->gamma);
	fprintf(fileptr, "model->c: %lf\n", model->c);
	fprintf(fileptr, "model->C: %d\n", model->C);
	fprintf(fileptr, "model->L: %d\n", model->L);
	fprintf(fileptr, "model->ell: %lf\n", model->ell);
	fprintf(fileptr, "model->nu: %lf\n", model->nu);
	fprintf(fileptr, "model->omega: %lf\n", model->omega);
	fclose(fileptr);

	sprintf(str, "%s/model_n.txt", file);
	cts->n->save(str, 'o', false);

	sprintf(str, "%s/model_eta.txt", file);
	fileptr = fopen(str, "w");
	for(int l = 0; l < model->L; l++){
		for(int k = 0; k < model->K + 1; k++){
			fprintf(fileptr, "%lf ", model->eta[l][k]);
		}
		fprintf(fileptr, "\n");
	}
	fclose(fileptr);

	sprintf(str, "%s/model_lambda.txt", file);
	fileptr = fopen(str, "w");
	for(int d = 0; d < D; d++){
		fprintf(fileptr, "%lf ", cts->lambda[d]);
	}
	fclose(fileptr);

	sprintf(str, "%s/model_y.txt", file);
	fileptr = fopen(str, "w");
	for(int d = 0; d < D; d++){
		fprintf(fileptr, "%d ", cts->yd[d]);
	}
	fclose(fileptr);

	sprintf(str, "%s/model_Cy.txt", file);
	fileptr = fopen(str, "w");
	for(int l = 0; l < model->L; l++){
		fprintf(fileptr, "%d ", cts->Cy[l]);
	}
	fclose(fileptr);
}

/*
 * read topic assignment
 */
Assignment* read_topic_assignmnet(Corpus* c, char* file)
{
	Assignment* ass = new_assignment(c);
	FILE* fileptr;
	int j, l, tmp;
	char str[BUFSIZ];

	printf("Reading topic assignment ......\n");
	sprintf(str, "%s/z.txt", file);
	fileptr = fopen(str, "r");
	if(!fileptr){
		printf("Cannot open file %s\n", str);
		exit(0);
	}
	for(j = 0; j < c->ndocs; j++){
		for(l = 0; l < c->docs[j].total; ++l){
			tmp = fscanf(fileptr, "%d ", &ass->topic_ass[j][l]);
			assert(tmp == 1);
		}
		tmp = fscanf(fileptr, "\n");
	}
	fclose(fileptr);

	printf("Finished!!!\n");
	return ass;
}

void save_topic_assignmnet(Corpus* c, Assignment* ass, char* file)
{
	FILE* fileptr;
	int j, l;
	char str[BUFSIZ];

	printf("Saving topic assignment ......\n");
	sprintf(str, "%s/z.txt", file);
	fileptr = fopen(str, "w");
	for(j = 0; j < c->ndocs; j++){
		for(l = 0; l < c->docs[j].total; ++l){
			fprintf(fileptr, "%d ", ass->topic_ass[j][l]);
		}
		fprintf(fileptr, "\n");
	}
	fclose(fileptr);
	printf("Finished!!!\n");
}

void print_top_words(int num_words, int begin_k, int end_k, int **M, Cts* cts, vocabulary* v, char* file)
{
	FILE* fileptr;
	int k, i, j;
	int word_id;
	gsl_vector* vector;
	int V, total_c = 0;
	V = v->size;

	for(k = 0; k < (*cts->n).rows()-1; k++){
		total_c += cts->M[k];
		//printf("k = %d, M = %d, total_c = %d\n", k, cts->M[k], total_c);
	}
	assert(total_c > 0);

	fileptr = fopen(file, "w");
	vector = gsl_vector_alloc(V);
	for (k = begin_k; k <= end_k; k++){
		fprintf(fileptr, "------topic_%d (%lf)------\n", k - begin_k, ((double)cts->M[k]) / (double)total_c);
		for(i = 0; i < V; i++){
			vset(vector, i, (double)M[k][i]);
		}
		sort(vector);
		for (i = 0; i < num_words; i++){
			word_id = (int) vget(vector, i);
			for (j = 0; j < V; j++){
				if (v->word_map[j].id == word_id) {
					fprintf(fileptr, "%s(%d) ", v->word_map[j].word_str, M[k][word_id]);
					break;
				}
			}
		}
		fprintf(fileptr, "\n");
	}
	fclose(fileptr);
	gsl_vector_free(vector);
}

/*
 * Note: free topic assignment must before free corpus!!!
 */
void free_assignment(Assignment* ass, Corpus* c)
{
	int j;

	for (j = 0; j < c->ndocs; j++){
		free(ass->topic_ass[j]);
	}
	free(ass->topic_ass);
	free(ass);
}
/*
 * Note free plda_ct must before free corpus !!!
 */
void free_cts(Cts* cts, Corpus* c, int k)
{
	int j;

	free(cts->N);
	free(cts->M);
	delete cts->n;
	for(j = 0; j < k; ++j){
		free(cts->m[j]);
	}
	free(cts->m);
	free(cts->lambda);
	free(cts->yd);
	free(cts->Cy);
	free(cts);
}
void free_model(Model* model)
{
	for(int l = 0; l < model->maxL; l++){
		if(model->eta[l]){
			free(model->eta[l]);
		}
		if(model->eta_z[l]){
			free(model->eta_z[l]);
		}
	}
	free(model);
	free(model->eta_z);
	for(int i = 0; i < model->C; i++){
		if(model->eta_aux[i]){
			free(model->eta_aux[i]);
		}
		if(model->eta_z_aux[i]){
			free(model->eta_z_aux[i]);
		}
	}
	free(model->eta_aux);
	free(model->eta_z_aux);

	//free(model->eta_sum);
}

/*
 *
 */
void free_all(Corpus* c, Model* model, Cts* cts, Assignment* ass, vocabulary* v)
{
	free_cts(cts, c, model->K);
	free_model(model);
	free_assignment(ass, c);
	free_corpus(c);
	if(v){
		free_vocabulary(v);
	}
	printf("--- All space is freed!!!\n");
}

