/*
 * params.c
 *
 */
#include <stdio.h>
#include <stdlib.h>
#include <assert.h>

#include "params.h"

dpyp_params PARAMS;

void new_params(int K, dpyp_params* params)
{
	params->train_data = (char*)malloc(sizeof(char) * 50);
	params->test_data = (char*)malloc(sizeof(char) * 50);
}

void free_params(dpyp_params* params)
{
	if(params->train_data){
		free(params->train_data);
	}
	if(params->test_data){
		free(params->test_data);
	}
}

void read_test_params(char* filename)
{
	FILE* fileptr;
	int tmp;

	fileptr = fopen(filename, "r");
	tmp = fscanf(fileptr, "gibbs max iter: %d\n", &(PARAMS.gibbs_max_iter));
	assert(tmp == 1);
	tmp = fscanf(fileptr, "burn in: %d\n", &(PARAMS.burn_in));
	assert(tmp == 1);
	tmp = fscanf(fileptr, "sampling lag: %d\n", &(PARAMS.sampling_lag));
	assert(tmp == 1);
	tmp = fscanf(fileptr, "train files:");
	PARAMS.train_data = (char*)malloc(sizeof(char) * 30);
	tmp = fscanf(fileptr, " %s\n", PARAMS.train_data);
	assert(tmp == 1);
	tmp = fscanf(fileptr, "test files:");
	PARAMS.test_data = (char*)malloc(sizeof(char) * 30);
	tmp = fscanf(fileptr, " %s", PARAMS.test_data);
	assert(tmp == 1);
	fclose(fileptr);
}

void read_params(char* filename, int test) {
	FILE* fileptr;
	int tmp;

	fileptr = fopen(filename, "r");
	tmp = fscanf(fileptr, "c: %lf\n", &(PARAMS.c));
	assert(tmp == 1);
	tmp = fscanf(fileptr, "C: %d\n", &(PARAMS.C));
	assert(tmp == 1);
	tmp = fscanf(fileptr, "L: %d\n", &(PARAMS.L));
	assert(tmp == 1);
	tmp = fscanf(fileptr, "ell: %lf\n", &(PARAMS.ell));
	assert(tmp == 1);
	tmp = fscanf(fileptr, "nu: %lf\n", &(PARAMS.nu));
	assert(tmp == 1);
	tmp = fscanf(fileptr, "omega: %lf\n", &(PARAMS.omega));
	assert(tmp == 1);
	tmp = fscanf(fileptr, "gamma: %lf\n", &(PARAMS.gamma));
	assert(tmp == 1);
	tmp = fscanf(fileptr, "train percent: %lf\n", &(PARAMS.tr_percent));
	assert(tmp == 1);
	assert(PARAMS.tr_percent > 0 && PARAMS.tr_percent <= 1);
	tmp = fscanf(fileptr, "gibbs max iter: %d\n", &(PARAMS.gibbs_max_iter));
	assert(tmp == 1);
	tmp = fscanf(fileptr, "burn in: %d\n", &(PARAMS.burn_in));
	assert(tmp == 1);
	tmp = fscanf(fileptr, "sampling lag: %d\n", &(PARAMS.sampling_lag));
	assert(tmp == 1);
	tmp = fscanf(fileptr, "K: %d\n", &(PARAMS.K_i));
	assert(tmp == 1);
	tmp = fscanf(fileptr, "alpha: %lf\n", &(PARAMS.alpha));
	assert(tmp == 1);
	tmp = fscanf(fileptr, "top words: %d\n", &(PARAMS.top_words));
	assert(tmp == 1);
	PARAMS.train_data = (char*)malloc(sizeof(char) * 30);
	tmp = fscanf(fileptr, "train files: %s\n", PARAMS.train_data);
	assert(tmp == 1);
	if(test){
		PARAMS.test_data = (char*)malloc(sizeof(char) * 30);
		tmp = fscanf(fileptr, "test files: %s\n", PARAMS.test_data);
		assert(tmp == 1);
	}else{
		PARAMS.test_data = NULL;
	}

	fclose(fileptr);
}

void write_params(char* filename) {
	FILE* fileptr;
	fileptr = fopen(filename, "w");

	fprintf(fileptr, "c: %lf\n", PARAMS.c);
	fprintf(fileptr, "C: %d\n", PARAMS.C);
	fprintf(fileptr, "L: %d\n", PARAMS.L);
	fprintf(fileptr, "ell: %lf\n", PARAMS.ell);
	fprintf(fileptr, "nu: %lf\n", PARAMS.nu);
	fprintf(fileptr, "omega: %lf\n", PARAMS.omega);
	fprintf(fileptr, "gamma: %lf\n", PARAMS.gamma);
	fprintf(fileptr, "train percent: %lf\n", PARAMS.tr_percent);
	fprintf(fileptr, "gibbs max iter: %d\n", PARAMS.gibbs_max_iter);
	fprintf(fileptr, "burn in: %d\n", PARAMS.burn_in);
	fprintf(fileptr, "sampling lag: %d\n", PARAMS.sampling_lag);
	fprintf(fileptr, "K: %d\n", PARAMS.K_i);
	fprintf(fileptr, "alpha: %lf\n", PARAMS.alpha);
	fprintf(fileptr, "top words: %d\n", PARAMS.top_words);
	fprintf(fileptr, "train files: %s\n", PARAMS.train_data);
	fprintf(fileptr, "test files: %s\n", PARAMS.test_data);

	fclose(fileptr);
}

void print_params() {
	printf(">>>>>> parameters <<<<<<\n");

	printf("c: %lf\n", PARAMS.c);
	printf("c: %d\n", PARAMS.C);
	printf("L: %d\n", PARAMS.L);
	printf("ell: %lf\n", PARAMS.ell);
	printf("nu: %lf\n", PARAMS.nu);
	printf("omega: %lf\n", PARAMS.omega);
	printf("gamma: %lf\n", PARAMS.gamma);
	printf("train percent: %lf\n", PARAMS.tr_percent);
	printf("gibbs max iter: %d\n", PARAMS.gibbs_max_iter);
	printf("burn in: %d\n", PARAMS.burn_in);
	printf("sampling lag: %d\n", PARAMS.sampling_lag);
	printf("K: %d\n", PARAMS.K_i);
	printf("alpha: %lf\n", PARAMS.alpha);
	printf("top words: %d\n", PARAMS.top_words);
	printf("train files: %s\n", PARAMS.train_data);
	printf("test files: %s\n", PARAMS.test_data);

	printf(">>>>>> parameters <<<<<<\n");
}

void set_paras(int K, double alpha, double gamma, double c, int C, double L, double ell, double nu,
		double omega, double tr_per, int gibbs_max_iter, int burn_in, int sampling_lag, int top_words)
{
	PARAMS.c = c;
	PARAMS.C = C;
	PARAMS.gamma = gamma;
	PARAMS.L = L;
	PARAMS.ell = ell;
	PARAMS.nu = nu;
	PARAMS.omega = omega;
	PARAMS.tr_percent = tr_per;
	PARAMS.gibbs_max_iter = gibbs_max_iter;
	PARAMS.burn_in = burn_in;
	PARAMS.sampling_lag = sampling_lag;
	PARAMS.K_i = K;
	PARAMS.alpha = alpha;
	PARAMS.top_words = top_words;
}

void default_params() {

}
