/*
 * gibbs.c
 *
 */
#include "gibbs.h"
#include <gsl/gsl_randist.h>

/*
 * uniformly initialize the topic assignment of each word
 */

void init_state_gibbs(Model* model, Cts* cts, Assignment* ass, Corpus* c, int est_inf, int init_z)
{
	int i, j, l, k, q, v, w;
	time_t seed;
	gsl_rng* r;

	printf(">>>>>> Begin initialize the states ......\n");

	for(j = 0; j < c->ndocs; ++j){
		cts->N[j] = 0;
		for(k = 0; k < model->K; ++k){
			cts->n[j][k] = 0;
		}
	}
	r = gsl_rng_alloc(gsl_rng_taus);
	time(&seed);
//	seed = 1115574245;
	gsl_rng_set(r, (long)seed);

	for (j = c->ndocs - 1; j >= 0; j--){
		for (l = 0; l < c->docs[j].total; l++){
			if(init_z){
				q = ass->topic_ass[j][l];
			}else{
				q = (int)floor(gsl_rng_uniform(r) * model->K);
				ass->topic_ass[j][l] = q;
			}
			cts->n[j][q] += 1;
			cts->N[j] += 1;
		}
	}

	for(int k = 0; k < model->K; k++){
		double s = 0;
		for(int v = 0; v < model->v; v++){
			int idx = k * model->v + v;
			double tmp = gsl_ran_gamma(r, model->gamma, 1);assert(tmp > 0);
			vset(model->theta, idx, tmp);
			mset(model->phi, k, v, tmp);
			s += tmp;
		}
		for(int v = 0; v < model->v; v++){
			mset(model->phi, k, v, mget(model->phi, k, v) / s);
		}
	}

	gsl_rng_free(r);
	printf("The seed for init_gibbs: %ld\n", (long)seed);
	printf("<<<<<< End initialization \n");
}

