/*
 * model.h
 *
 */

#ifndef MODEL_H_
#define MODEL_H_

#include <gsl/gsl_matrix.h>
#include <gsl/gsl_vector.h>

#include "corpus.h"

typedef struct Model {
	int v; // total vocabulary length
	int K; //number of topics for each class data
	double gamma;
	double alpha;
	double ALPHA;
	double C;
	double ETA;
	int NUMLF;
	int BATCHSIZE;

	gsl_matrix* phi;
	gsl_vector* theta;

} Model;

/*
 * count tables
 */
typedef struct Cts {
	int** n; // d_i * K_i
	int* N; // d_i
	int** m; // K * W
	int* M; //K
} Cts;

/*
 * topic assignments
 */
typedef struct assignment {
	int** topic_ass; //D * L_{D_i}
} Assignment;

/*
 * functions
 */
Model* new_model(int v, int K);
Cts* new_cts(int K, int v, Corpus* c);
Assignment* new_assignment(Corpus* c);

Model* random_init(int K, int v, double alpha, double gamma,
		double ALPHA, double ETA, double C, int NUMLF, int BATCHSIZE);
Model* read_model(char* file);
void save_model(Model* model, gsl_matrix* mphi, char* file);

Assignment* read_topic_assignmnet(Corpus* c, char* file);
void save_topic_assignmnet(Corpus* c, Assignment* ass, char* file);
void print_top_words(int num_words, int begin_k, int end_k, gsl_matrix* M, Cts* cts, vocabulary* v,
		char* file);

void free_assignment(Assignment*, Corpus* c);
void free_cts(Cts*, Corpus* c, int K);
void free_model(Model*);
void free_all(Corpus*, Model*, Cts*, Assignment*, vocabulary*);


#endif /* MODEL_H_ */
