/*
 * params.c
 *
 */
#include <stdio.h>
#include <stdlib.h>
#include <assert.h>

#include "params.h"

dpyp_params PARAMS;

void new_params(int K, dpyp_params* params)
{
	params->train_data = (char*)malloc(sizeof(char) * 50);
}

void free_params(dpyp_params* params)
{
	free(params->train_data);
}

void read_test_params(char* filename)
{
	FILE* fileptr;
	int tmp;

	fileptr = fopen(filename, "r");
	tmp = fscanf(fileptr, "gibbs max iter: %d\n", &(PARAMS.gibbs_max_iter));
	assert(tmp == 1);
	tmp = fscanf(fileptr, "burn in: %d\n", &(PARAMS.burn_in));
	assert(tmp == 1);
	tmp = fscanf(fileptr, "sampling lag: %d\n", &(PARAMS.sampling_lag));
	assert(tmp == 1);
	tmp = fscanf(fileptr, "train files:");
	PARAMS.train_data = (char*)malloc(sizeof(char) * 30);
	tmp = fscanf(fileptr, " %s", PARAMS.train_data);
	assert(tmp == 1);
	fclose(fileptr);
}

void read_params(char* filename) {
	FILE* fileptr;
	int tmp;

	fileptr = fopen(filename, "r");
	tmp = fscanf(fileptr, "gamma: %lf\n", &(PARAMS.gamma));
	assert(tmp == 1);
	tmp = fscanf(fileptr, "train percent: %lf\n", &(PARAMS.tr_percent));
	assert(tmp == 1);
	assert(PARAMS.tr_percent > 0 && PARAMS.tr_percent <= 1);
	tmp = fscanf(fileptr, "gibbs max iter: %d\n", &(PARAMS.gibbs_max_iter));
	assert(tmp == 1);
	tmp = fscanf(fileptr, "burn in: %d\n", &(PARAMS.burn_in));
	assert(tmp == 1);
	tmp = fscanf(fileptr, "sampling lag: %d\n", &(PARAMS.sampling_lag));
	assert(tmp == 1);
	tmp = fscanf(fileptr, "K: %d\n", &(PARAMS.K_i));
	assert(tmp == 1);
	tmp = fscanf(fileptr, "alpha: %lf\n", &(PARAMS.alpha));
	assert(tmp == 1);
	tmp = fscanf(fileptr, "ALPHA: %lf\n", &(PARAMS.ALPHA));
	assert(tmp == 1);
	//tmp = fscanf(fileptr, "ETA: %e\n", &(PARAMS.ETA));
	tmp = fscanf(fileptr, "ETA: %lf\n", &(PARAMS.ETA));
	assert(tmp == 1);
	tmp = fscanf(fileptr, "C: %lf\n", &(PARAMS.C));
	assert(tmp == 1);
	tmp = fscanf(fileptr, "NUMLF: %d\n", &(PARAMS.NUMLF));
	assert(tmp == 1);
	tmp = fscanf(fileptr, "BATCHSIZE: %d\n", &(PARAMS.BATCHSIZE));
	assert(tmp == 1);
	tmp = fscanf(fileptr, "top words: %d\n", &(PARAMS.top_words));
	assert(tmp == 1);
	PARAMS.train_data = (char*)malloc(sizeof(char) * 30);
	tmp = fscanf(fileptr, "train files: %s", PARAMS.train_data);
	assert(tmp == 1);

	fclose(fileptr);
}

void write_params(char* filename) {
	FILE* fileptr;
	fileptr = fopen(filename, "w");

	fprintf(fileptr, "gamma: %lf\n", PARAMS.gamma);
	fprintf(fileptr, "train percent: %lf\n", PARAMS.tr_percent);
	fprintf(fileptr, "gibbs max iter: %d\n", PARAMS.gibbs_max_iter);
	fprintf(fileptr, "burn in: %d\n", PARAMS.burn_in);
	fprintf(fileptr, "sampling lag: %d\n", PARAMS.sampling_lag);
	fprintf(fileptr, "K: %d\n", PARAMS.K_i);
	fprintf(fileptr, "alpha: %lf\n", PARAMS.alpha);
	fprintf(fileptr, "ALPHA: %lf\n", PARAMS.ALPHA);
	fprintf(fileptr, "ETA: %e\n", PARAMS.ETA);
	fprintf(fileptr, "C: %lf\n", PARAMS.C);
	fprintf(fileptr, "NUMLF: %d\n", PARAMS.NUMLF);
	fprintf(fileptr, "BATCHSIZE: %d\n", PARAMS.BATCHSIZE);
	fprintf(fileptr, "top words: %d\n", PARAMS.top_words);
	fprintf(fileptr, "train files: %s\n", PARAMS.train_data);

	fclose(fileptr);
}

void print_params() {
	int i;
	printf(">>>>>> parameters <<<<<<\n");

	printf("gamma: %lf\n", PARAMS.gamma);
	printf("train percent: %lf\n", PARAMS.tr_percent);
	printf("gibbs max iter: %d\n", PARAMS.gibbs_max_iter);
	printf("burn in: %d\n", PARAMS.burn_in);
	printf("sampling lag: %d\n", PARAMS.sampling_lag);
	printf("K: %d\n", PARAMS.K_i);
	printf("alpha: %lf\n", PARAMS.alpha);
	printf("ALPHA: %lf\n", PARAMS.ALPHA);
	printf("ETA: %e\n", PARAMS.ETA);if(PARAMS.ETA == 0){printf("sdfsd\n"); exit(1);}
	printf("C: %lf\n", PARAMS.C);
	printf("NUMLF: %d\n", PARAMS.NUMLF);
	printf("BATCHSIZE: %d\n", PARAMS.BATCHSIZE);
	printf("top words: %d\n", PARAMS.top_words);
	printf("train files: %s\n", PARAMS.train_data);

	printf(">>>>>> parameters <<<<<<\n");
}

void set_paras(int K, double alpha, double ALPHA, double ETA, double C,
		int NUMLF, int BATCHSIZE, double gamma,
		double tr_per, int gibbs_max_iter, int burn_in, int sampling_lag, int top_words)
{
	PARAMS.gamma = gamma;
	PARAMS.tr_percent = tr_per;
	PARAMS.gibbs_max_iter = gibbs_max_iter;
	PARAMS.burn_in = burn_in;
	PARAMS.sampling_lag = sampling_lag;
	PARAMS.K_i = K;
	PARAMS.alpha = alpha;
	PARAMS.ALPHA = ALPHA;
	PARAMS.ETA = ETA;
	PARAMS.C = C;
	PARAMS.NUMLF = NUMLF;
	PARAMS.BATCHSIZE = BATCHSIZE;
	PARAMS.top_words = top_words;
}

void default_params() {

}
