/*
 * params.h
 *
 */

#ifndef PARAMS_H_
#define PARAMS_H_

typedef struct dpyp_params {
	int K_i;
	double alpha;
	double gamma;
	double tr_percent;
	double ALPHA;
	double ETA;
	double C;
	int NUMLF;
	int BATCHSIZE;
	int gibbs_max_iter;
	int burn_in;
	int sampling_lag;
	int top_words;
	char* train_data;
} dpyp_params;

void new_params(int K, dpyp_params* params);
void free_params(dpyp_params* params);
void read_test_params(char*);

void read_params(char*);
void write_params(char*);
void print_params();
void default_params();
void set_paras(int K, double alpha, double ALPHA, double ETA, double C,
		int NUMLF, int BATCHSIZE, double gamma,
		double tr_per, int gibbs_max_iter, int burn_in, int sampling_lag, int top_words);
#endif /* PARAMS_H_ */
