/*
 * seqTM.h
 *
 */

#ifndef SEQTM_H_
#define SEQTM_H_

#include "corpus.h"
#include "model.h"

void estimate(Corpus* c_tr, Corpus* c_te, vocabulary* v, char* root, char* data_dir, int init, char* z_root);

double spyp_marg_lglihood(Corpus* c, Cts* cts, Model* model);

void gamma_opt(Cts* cts, Model* model, Corpus* c);
void gamma_opt_newton(Cts* cts, Model* model, Corpus* c);
void alpha_opt(Cts* cts, Model* model, int* nDoc, int K);
void alpha_opt_newton(Cts* cts, Model* model, int* nDoc, int K);
void sample_alpha(Cts* cts, Model* model, Corpus* c);

int directory_exist(const char *dname);

#endif /* SEQTM_H_ */
