/*
 * inf_Gibbs.c
 *
 */
#include <iostream>
#include "gibbs.h"
#include "params.h"


extern dpyp_params PARAMS;
extern double* vector;

static int held_out_sample_topic(int d, int l, int w, Assignment* ass, Cts* cts, Model* model)
{
	int old_topic, new_topic;
	int k, KK;
	double sum_v;

	if(w > model->phi->size2){
		std::cout << "w = " << w << ", phi->size2 = " << model->phi->size2 << std::endl;
		assert(w < model->phi->size2);
	}

	KK = model->K;
	old_topic = ass->topic_ass[d][l];
	cts->n[d][old_topic] -= 1;

	for(k = 0; k < KK; ++k){
		double r = (model->alpha + cts->n[d][k]) * mget(model->phi, k, w);
		vector[k] = r;
	}

	sum_v = 0;
	for(k = 0; k < KK; ++k)
		sum_v += vector[k];
	for(k = 0; k < KK; ++k)
		vector[k] = vector[k] / sum_v;
	new_topic = next_discrete_normalised(vector, KK);

	ass->topic_ass[d][l] = new_topic;
	cts->n[d][new_topic] += 1;

	return new_topic;
}


void held_out_gibbs(Model* model, Cts* cts, Assignment* ass, Corpus* c)
{
	int d, l;

	for(d = 0; d < c->ndocs; ++d){
		for(l = 0; l < c->docs[d].total; ++l){
			held_out_sample_topic(d, l, c->docs[d].words[l], ass, cts, model);
		}
	}
}

