function batchwords = GetBatch(fid, nbatch, trainfile)

if fid < 0
    fid = fopen(trainfile);
end

batchwords = cell(1, nbatch);

line = fgets(fid);
f = 1;
while ischar(line)
    c = textscan(line, '%d');
    c = c{1};
    p = randperm(length(c));
    batchwords{f} = c(p) + 1;
    if f == nbatch
        break;
    end
    f = f + 1;
    line = fgets(fid);
end

if f ~= nbatch && ~ischar(line)
    fclose(fid);
    fid = fopen(trainfile);
end

while 1
    if f == nbatch
        break;
    end
    line = fgets(fid);
    assert(ischar(line));
    c = textscan(line, '%d');
    c = c{1};
    p = randperm(length(c));
    batchwords{f} = c(p) + 1;    
    if f == nbatch
        break;
    end
    f = f + 1;
end
