// ============================================================================ 
// UBHeap.cpp
// ~~~~~~~~~~
// hqn
// - implement the UBHeap interface
// ============================================================================ 

#include <sstream>
#include <stdexcept>

#include "UBHeap.h"

using namespace std; // BAD PRACTICE

UBHeap::UBHeap(const std::vector<int>& a)
{
    heap_ = a;
    heapify();
}

UBHeap& UBHeap::operator=(const UBHeap& theOther)
{
    heap_ = theOther.heap_;
    return *this;
}

void UBHeap::heapify()
{
    for (int i=heap_.size()/2; i>=0; --i)
        sink(i);
}

void UBHeap::floatUp(size_t i)
{
    if (i >= heap_.size())
        throw runtime_error("Floating out of range index");
    size_t p;
    while (i > 0) {
        p = (i-1)/2;
        if (heap_[i] > heap_[p]) {
            std::swap(heap_[i], heap_[p]);
            i = p;
        } else {
            break;
        }
    }
}

void UBHeap::sink(size_t i)
{
    size_t left = 2*i + 1;
    if (left >= heap_.size()) 
        return;
    size_t right = left + 1; // possibly >= heap_.size();
    size_t my_pick = (right >= heap_.size()) ?  
                         left : 
                         (heap_[right] > heap_[left]) ? right : left;

    if (heap_[i] < heap_[my_pick]) {
        std::swap(heap_[i], heap_[my_pick]);
        sink(my_pick);
    }

}


string UBHeap::toString()
{
    ostringstream oss;
    for (size_t i=0; i<heap_.size(); ++i) {
        oss << heap_[i] << " ";
    }
    return oss.str();
}

bool UBHeap::empty()
{
    return heap_.size() == 0;
}

void UBHeap::push(int x)
{
    heap_.push_back(x);
    floatUp(heap_.size()-1);
}

void UBHeap::pop()
{
    if (empty()) {
        throw runtime_error("Heap is Empty");
    } else {
        std::swap(heap_.front(), heap_.back());
        heap_.pop_back();
        sink(0);
    }
}

int UBHeap::top()
{
    if (empty()) {
        throw runtime_error("Heap is Empty");
    } else {
        return heap_[0];
    }
}
