function h = plot_dataset2(D)

% function plot_dataset2(D)
%
%  Creates a figure and plots the dataset in D
%
% D is 3 by n samples
%  The third row specifies the class (but is discarded in this plotting)


h = figure;
a = axes;

colordef none; colormap jet;



set(a,'XLim',[-100,100]);
set(a,'YLim',[-100,100]);
set(a,'XTick',[-100:50:100]);
set(a,'YTick',[-100:50:100]);
set(a,'XGrid','on');
set(a,'YGrid','on');

hold on;

n = size(D,2);

if (size(D,1)>=2)
    scatter(D(1,:),D(2,:),30,[1:n]);
else
    scatter(D(1,:),ones(1,n),30,[1:n]);    
end
