function [alpha, pEval]= ForwardProb(A, B, Pi, O)

numStates = size(A,1);
numObs = size(O,1);
alpha = zeros(numStates, numObs);

for i = 1 : numStates
    alpha(i, 1) = Pi(i)*B(i, O(1));
end

for t = 2 : numObs
    for j = 1 : numStates
        alpha(j, t) = sum(alpha(:,t-1).*A(:,j))*B(j, O(t));
    end
end

pEval = sum(alpha(:, numObs));