function [cat_compare, con_compare] = evaluate_weather(truth,ground_truth )
%% function discription
% ----------------------------------------------------------------------
% Function for evaluation the results for weather data
% Qi Li
% version 2
% Input:   
%          truth--the fusion result to be evaluated on. It contains 2 columns
%                 The 1st column is entry id index
%                 The 2nd column is observation value
%
%          ground_truth--the ground truth. It contains 2 columns
%                        The 1st column is entry id index
%                        The 2nd column is ground truth value
%
% Output:  
%          cat_compare--error rate on categorical data
%
%          con_compare--MNAD on continuous data
% ----------------------------------------------------------------------

%% initalize
con_compare=0;
cat_compare=0;
ct_length=size(ground_truth,1);
cat_all=0;
con_all=0;

%% for each entry with ground truth
for i = 1:ct_length
    
    % get the entry index
    index=ground_truth{i,1};
    
        if ischar(ground_truth{i,2}) % categorical data 
            
            % count the number of match 
            cat_compare=cat_compare+strcmp(ground_truth{i,2},truth{index,2});
            cat_all=cat_all+1;
            
        else % continuous data
            
            % calcuate the sum of absolute distance
            con_compare=con_compare+abs(ground_truth{i,2}-truth{index,2});
            con_all=con_all+1;
        end
end

%% calculate error rate and MNAD
cat_compare=(cat_all-cat_compare)/cat_all;
con_compare=con_compare/con_all;