function weathergroundtruthCopy = importfile_gt(filename, startRow, endRow)
%IMPORTFILE Import numeric data from a text file as a matrix.
%   WEATHERGROUNDTRUTHCOPY = IMPORTFILE(FILENAME) Reads data from text file
%   FILENAME for the default selection.
%
%   WEATHERGROUNDTRUTHCOPY = IMPORTFILE(FILENAME, STARTROW, ENDROW) Reads
%   data from rows STARTROW through ENDROW of text file FILENAME.
%
% Example:
%   weathergroundtruthCopy = importfile('weather_ground_truth - Copy.txt',
%   1, 1739);
%
%    See also TEXTSCAN.

% Auto-generated by MATLAB on 2014/04/24 16:16:11

%% Initialize variables.
delimiter = '\t';
if nargin<=2
    startRow = 1;
    endRow = inf;
end

%% Format string for each line of text:
%   column1: double (%f)
%	column2: text (%s)
% For more information, see the TEXTSCAN documentation.
formatSpec = '%f%s%[^\n\r]';

%% Open the text file.
fileID = fopen(filename,'r');

%% Read columns of data according to format string.
% This call is based on the structure of the file used to generate this
% code. If an error occurs for a different file, try regenerating the code
% from the Import Tool.
dataArray = textscan(fileID, formatSpec, endRow(1)-startRow(1)+1, 'Delimiter', delimiter, 'HeaderLines', startRow(1)-1, 'ReturnOnError', false);
for block=2:length(startRow)
    frewind(fileID);
    dataArrayBlock = textscan(fileID, formatSpec, endRow(block)-startRow(block)+1, 'Delimiter', delimiter, 'HeaderLines', startRow(block)-1, 'ReturnOnError', false);
    for col=1:length(dataArray)
        dataArray{col} = [dataArray{col};dataArrayBlock{col}];
    end
end

%% Close the text file.
fclose(fileID);

%% Post processing for unimportable data.
% No unimportable data rules were applied during the import, so no post
% processing code is included. To generate code which works for
% unimportable data, select unimportable cells in a file and regenerate the
% script.

%% Create output variable
dataArray(1) = cellfun(@(x) num2cell(x), dataArray(1), 'UniformOutput', false);
weathergroundtruthCopy = [dataArray{1:end-1}];
%% Change numbers' format back to float
for i=1:size(weathergroundtruthCopy,1)
    if ~isempty(str2num(weathergroundtruthCopy{i,2}))
    weathergroundtruthCopy{i,2}=str2num(weathergroundtruthCopy{i,2});
    end
end
%% sort based on entry id
[~,indexofsort_gt]=sort([weathergroundtruthCopy{:,1}]);
ground_truth_all_temp=weathergroundtruthCopy(indexofsort_gt,:);
ground_truth=ground_truth_all_temp;
weathergroundtruthCopy=ground_truth;