clear
%% import data and ground truth

% import data
weather=importfile_data('..\data\weather_data_set.txt');

% import ground truth
ground_truth=importfile_gt('..\data\weather_ground_truth.txt');

%% run CRH method

% set minimum iterations
min_iti = 3;
% set maximum iterations
max_iti = 3;

i=0;
% start CRH iteration
for iti = min_iti : max_iti
    i = i + 1;
    str = [num2str(i), 'th run:  iteration = ', num2str(iti), '  ... ...'];
    disp(str);
    
    % run CRH
    [crh_truth, crh_weight, voting_median_truth] =  CRH_weather(weather,iti);
    
    % evaluate CRH result for current iteration
    [error_rate, MNAD] = evaluate_weather(crh_truth, ground_truth);
    result_CRH(i,:) = [iti, error_rate, MNAD];
end

% save CRH result
disp('saving CRH result...');
save('result_CRH.txt', 'result_CRH', '-ASCII');

%% Voting/Median method
% if you want to evaluate the results from Voting/Median method, you can
% uncommand the following code and run the script:

% % evaluate Voting/Median result for current iteration
% [error_rate, MNAD] = evaluate_truthmine(crh_truth, ground_truth);
% result_vm = [error_rate, MNAD];
% 
% % save Voting/Median result
% disp('saving Voting/Median result...');
% save('result_vm.txt', 'result_vm', '-ASCII');
