package converter;

import java.math.*;

public class ConverterBean {

	private String usdAmount = "0.0";
	private String yenRate = "88.75";
	private BigDecimal yenAmount;

	/**
	 * @return the usdAmount
	 */
	public String getUsdAmount() {
		return usdAmount;
	}

	/**
	 * @param usdAmountStr
	 *            the usdAmount to set
	 */
	public void setUsdAmount(String usdAmountStr) {
		usdAmount = usdAmountStr;
		BigDecimal amount = null;
		if (usdAmount == null || usdAmount.isEmpty())
			usdAmount = "0.0";
		amount = new BigDecimal(usdAmount);
		yenAmount = amount.multiply(new BigDecimal(yenRate));
		yenAmount = yenAmount.setScale(2, BigDecimal.ROUND_UP);
	}

	/**
	 * @param yenRate
	 *            the yenRate to set
	 */
	public void setYenRate(String yenRate) {
		this.yenRate = yenRate;
		if (yenRate == null || yenRate.isEmpty())
			this.yenRate = "0.0";
	}

	/**
	 * @return the yenAmount
	 */
	public BigDecimal getYenAmount() {
		return yenAmount;
	}

}
