package dataentry;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

import javax.naming.NamingException;

public class StudentBean {

	private Integer id = null;
	private String first = null;
	private String middle = null;
	private String last = null;

	private String selectStr = "SELECT * FROM Students";
	private String insertStr = "INSERT INTO Students VALUES (?, ?, ?, ?)";
	private String updateStr = "UPDATE Students SET firstName = ?, "
			+ "middleName = ?, lastName = ? WHERE ubid = ?";
	private String deleteStr = "DELETE FROM Students WHERE ubid = ?";

	private Connection conn = null;
	private PreparedStatement pStmt = null;
	private ResultSet allStudents = null;

	public Integer getId() {
		return id;
	}

	public void setId(Integer id) {
		this.id = id;
	}

	public String getFirst() {
		return first;
	}

	public void setFirst(String first) {
		this.first = first;
	}

	public String getMiddle() {
		return middle;
	}

	public void setMiddle(String middle) {
		this.middle = middle;
	}

	public String getLast() {
		return last;
	}

	public void setLast(String last) {
		this.last = last;
	}

	public ResultSet getAllStudents() throws SQLException, NamingException {

		conn = DBConnectionPool.getConnection();

		// Create the statement
		pStmt = conn.prepareStatement(selectStr);

		// Use the created statement to SELECT
		// the student attributes FROM the Student table.
		allStudents = pStmt.executeQuery();

		return allStudents;
	}

	public void insertStudent() throws SQLException, NamingException {

		conn = DBConnectionPool.getConnection();

		// Create the prepared statement and use it to
		// INSERT student values INTO the Students table.
		pStmt = conn.prepareStatement(insertStr);

		pStmt.setInt(1, id);
		pStmt.setString(2, first);
		pStmt.setString(3, middle);
		pStmt.setString(4, last);
		pStmt.executeUpdate();

		// Commit transaction
		conn.commit();

		close();
	}

	public void updateStudent() throws SQLException, NamingException {

		conn = DBConnectionPool.getConnection();

		// Create the prepared statement and use it to
		// UPDATE student values in the Students table.
		pStmt = conn.prepareStatement(updateStr);

		pStmt.setString(1, first);
		pStmt.setString(2, middle);
		pStmt.setString(3, last);
		pStmt.setInt(4, id);
		pStmt.executeUpdate();

		// Commit transaction
		conn.commit();

		close();
	}

	public void deleteStudent() throws SQLException, NamingException {

		conn = DBConnectionPool.getConnection();

		// Create the prepared statement and use it to
		// DELETE students FROM the Students table.
		pStmt = conn.prepareStatement(deleteStr);

		pStmt.setInt(1, id);
		pStmt.executeUpdate();

		// Commit transaction
		conn.commit();

		close();
	}

	public void close() throws SQLException {
		// release resources in a finally{} block
		// in reverse-order of their creation

		if (allStudents != null)
			allStudents.close();
		allStudents = null;

		if (pStmt != null)
			pStmt.close();
		pStmt = null;

		if (conn != null)
			conn.close();
		conn = null;
	}

	public void clear() {
		id = null;
		first = null;
		middle = null;
		last = null;
	}

}
