<%@ page import="dataentry.*, java.sql.*"%>

<jsp:useBean id="student" scope="session" class="dataentry.StudentBean"/>

<%-- -------- Application Logic Code -------- --%>
<%
	String action = request.getParameter("action");
	// Check if an insertion is requested
	if (action != null && action.equals("insert"))
		student.insertStudent();

	// Check if an update is requested
	else if (action != null && action.equals("update"))
		student.updateStudent();

	// Check if a delete is requested
	else if (action != null && action.equals("delete"))
		student.deleteStudent();

	ResultSet rs = student.getAllStudents();
%>

<html>

<body>
<table>
	<tr>
		<td valign="top">
			<%-- -------- Include menu HTML code -------- --%>
			<jsp:include page="../menu.html" />
		</td>
		<td>
			<!-- Add an HTML table header row to format the results -->
			<table>
			<tr>
				<th>UBID</th>
				<th>First Name</th>
				<th>Middle Name</th>
				<th>Last Name</th>
				<th>Action</th>
			</tr>
			<tr>
				<form action="verify.jsp" method="GET">
					<input type="hidden" name="action" value="insert"/>
					<th><input value="" name="id" size="10"/></th>
					<th><input value="" name="first" size="15"/></th>
					<th><input value="" name="middle" size="15"/></th>
					<th><input value="" name="last" size="15"/></th>
					<th><input type="submit" value="Insert"/></th>
				</form>
			</tr>

			<%-- -------- Iteration Code -------- --%>
			<%
				// Iterate over the ResultSet
				while (rs.next()) {
			%>

			<tr>
				<form action="verify.jsp" method="GET">
					<input type="hidden" name="action" value="update"/>
					<input type="hidden" name="id" value="<%=rs.getInt("ubid")%>"/>
				<%-- Get the ubid, which is a number --%>
				<td>
					<%=rs.getInt("ubid")%>
				</td>

				<%-- Get the first name --%>
				<td>
					<input value="<%=rs.getString("firstName")%>" name="first" size="15"/>
				</td>

				<%-- Get the middle name --%>
				<td>
					<% if (rs.getString("middleName") != null) { %>
					<input value="<%=rs.getString("middleName")%>" name="middle" size="15"/>
					<% } else { %>
					<input name="middle" size="15"/>
					<% } %>
				</td>

				<%-- Get the last name --%>
				<td>
					<input value="<%=rs.getString("lastName")%>" name="last" size="15"/>
				</td>

				<%-- Button --%>
				<td><input type="submit" value="Update"></td>
				</form>
				<td><a href="verify.jsp?action=delete&id=<%= rs.getInt("ubid") %>">Delete</a></td>
			</tr>
			<%
				}
			%>
		</table>
		</td>
	</tr>
</table>
</body>

</html>

<%-- -------- Close Code -------- --%>
<%
	student.close();
%>
