package dataentry;

import java.sql.Connection;
import java.sql.SQLException;

import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;

/**
 * Provides <code>java.sql.Connection</code> objects.
 * 
 * @author Michalis Petropoulos
 * 
 */
public class DBConnectionPool {

	private static Context ctx = null;
	private static DataSource ds = null;

	/**
	 * Returns a <code>java.sql.Connection</code> object.
	 * 
	 * @exception NamingException
	 *                if the JDBC resource is not found
	 * @exception SQLException
	 *                if a connection can not be obtained
	 * 
	 * @return Connection to use
	 */
	public static Connection getConnection() throws NamingException,
			SQLException {

		if (ctx == null) {
			ctx = new InitialContext();
			ds = (DataSource) ctx.lookup("java:comp/env/jdbc/ClassesDBPool");
		}

		return ds.getConnection();
	}

}
