package app.actions;

import java.io.IOException;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.apache.struts.action.Action;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;

import app.Constants;
import app.forms.LogonForm;
import app.model.UserDirectory;
import app.model.UserDirectoryException;

/**
 * Implementation of <strong>Action</strong> that validates a user logon.
 * 
 * @author Craig R. McClanahan
 * @author Ted Husted
 * @version $Revision: 1.1.1.1 $ $Date: 2002/08/15 15:50:55 $
 */
public final class LogonAction extends Action {

	/**
	 * Validate credentials with business tier.
	 * 
	 * @param username
	 *            The username credential
	 * @param password
	 *            The password credential
	 * @returns true if credentials can be validated
	 * @exception UserDirectoryException
	 *                if cannot access directory
	 */
	public boolean isUserLogon(String username, String password)
			throws UserDirectoryException {

		return (UserDirectory.getInstance().isValidPassword(username, password));
		// return true;

	}

	/**
	 * Login the user. The event is logged if the debug level is >=
	 * Constants.DEBUG.
	 * 
	 * @param mapping
	 *            The ActionMapping used to select this instance
	 * @param actionForm
	 *            The ActionForm bean for this request (if any)
	 * @param request
	 *            The HTTP request we are processing
	 * @param response
	 *            The HTTP response we are creating
	 * 
	 * @exception IOException
	 *                if an input/output error occurs
	 * @exception ServletException
	 *                if a servlet exception occurs
	 */
	public ActionForward execute(ActionMapping mapping, ActionForm form,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {

		// Obtain username and password from web tier
		String username = ((LogonForm) form).getUsername();
		String password = ((LogonForm) form).getPassword();

		// Validate credentials with business tier
		boolean validated = false;
		try {
			validated = isUserLogon(username, password);
		} catch (UserDirectoryException ude) {
			// couldn't connect to user directory
			ActionErrors errors = new ActionErrors();
			errors.add(ActionMessages.GLOBAL_MESSAGE, new ActionMessage(
					"error.logon.connect"));
			saveErrors(request, errors);
			// return to input page
			return (new ActionForward(mapping.getInput()));
		}

		if (!validated) {
			// credentials don't match
			ActionErrors errors = new ActionErrors();
			errors.add(ActionMessages.GLOBAL_MESSAGE, new ActionMessage(
					"error.logon.invalid"));
			saveErrors(request, errors);
			// return to input page
			return (new ActionForward(mapping.getInput()));
		}

		// Save our logged-in user in the session,
		// because we use it again later.
		HttpSession session = request.getSession();
		session.setAttribute(Constants.USER_KEY, form);

		// Log this event
		StringBuffer message = new StringBuffer("LogonAction: User '");
		message.append(username);
		message.append("' logged on in session ");
		message.append(session.getId());
		servlet.log(message.toString());

		// Return success
		return mapping.findForward(Constants.SUCCESS);
	}

} // End LogonAction
