/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.views.xslt;

import com.opensymphony.xwork2.util.logging.Logger;
import com.opensymphony.xwork2.util.logging.LoggerFactory;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.struts2.StrutsException;
import org.apache.struts2.views.xslt.AbstractAdapterElement;
import org.apache.struts2.views.xslt.AdapterFactory;
import org.apache.struts2.views.xslt.AdapterNode;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanAdapter
extends AbstractAdapterElement {
    private static final Object[] NULLPARAMS = new Object[0];
    private static Map<Class, PropertyDescriptor[]> propertyDescriptorCache;
    private Logger log = LoggerFactory.getLogger(this.getClass());

    public BeanAdapter() {
    }

    public BeanAdapter(AdapterFactory adapterFactory, AdapterNode parent, String propertyName, Object value) {
        this.setContext(adapterFactory, parent, propertyName, value);
    }

    @Override
    public String getTagName() {
        return this.getPropertyName();
    }

    @Override
    public NodeList getChildNodes() {
        NodeList nl = super.getChildNodes();
        if (this.log.isDebugEnabled() && nl != null) {
            this.log.debug("BeanAdapter getChildNodes for: " + this.getTagName(), new String[0]);
            this.log.debug(nl.toString(), new String[0]);
        }
        return nl;
    }

    @Override
    protected List<Node> buildChildAdapters() {
        this.log.debug("BeanAdapter building children.  PropName = " + this.getPropertyName(), new String[0]);
        ArrayList<Node> newAdapters = new ArrayList<Node>();
        Class<?> type = this.getPropertyValue().getClass();
        PropertyDescriptor[] props = this.getPropertyDescriptors(this.getPropertyValue());
        if (props.length > 0) {
            for (PropertyDescriptor prop : props) {
                Object propertyValue;
                Method m = prop.getReadMethod();
                if (m == null) continue;
                this.log.debug("Bean reading property method: " + m.getName(), new String[0]);
                String propertyName = prop.getName();
                try {
                    propertyValue = m.invoke(this.getPropertyValue(), NULLPARAMS);
                }
                catch (Exception e) {
                    if (e instanceof InvocationTargetException) {
                        e = (Exception)((InvocationTargetException)e).getTargetException();
                    }
                    this.log.error("Cannot access bean property: " + propertyName, (Throwable)e, new String[0]);
                    continue;
                }
                Node childAdapter = propertyValue == null ? this.getAdapterFactory().adaptNullValue(this, propertyName) : this.getAdapterFactory().adaptNode(this, propertyName, propertyValue);
                if (childAdapter != null) {
                    newAdapters.add(childAdapter);
                }
                if (!this.log.isDebugEnabled()) continue;
                this.log.debug(this + " adding adapter: " + childAdapter, new String[0]);
            }
        } else {
            this.log.info("Class " + type.getName() + " has no readable properties, " + " trying to adapt " + this.getPropertyName() + " with StringAdapter...", new String[0]);
        }
        return newAdapters;
    }

    private synchronized PropertyDescriptor[] getPropertyDescriptors(Object bean) {
        try {
            PropertyDescriptor[] props;
            if (propertyDescriptorCache == null) {
                propertyDescriptorCache = new HashMap<Class, PropertyDescriptor[]>();
            }
            if ((props = propertyDescriptorCache.get(bean.getClass())) == null) {
                this.log.debug("Caching property descriptor for " + bean.getClass().getName(), new String[0]);
                props = Introspector.getBeanInfo(bean.getClass(), Object.class).getPropertyDescriptors();
                propertyDescriptorCache.put(bean.getClass(), props);
            }
            return props;
        }
        catch (IntrospectionException e) {
            e.printStackTrace();
            throw new StrutsException("Error getting property descriptors for " + bean + " : " + e.getMessage());
        }
    }
}

