/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.config;

import java.util.HashSet;
import java.util.Iterator;
import org.apache.struts2.config.Settings;

class DelegatingSettings
extends Settings {
    Settings[] delegates;

    public DelegatingSettings(Settings[] delegates) {
        this.delegates = delegates;
    }

    public void setImpl(String name, String value) throws IllegalArgumentException, UnsupportedOperationException {
        IllegalArgumentException e = null;
        for (Settings delegate : this.delegates) {
            try {
                delegate.getImpl(name);
                delegate.setImpl(name, value);
                return;
            }
            catch (IllegalArgumentException ex) {
                e = ex;
            }
        }
        throw e;
    }

    public String getImpl(String name) throws IllegalArgumentException {
        IllegalArgumentException e = null;
        for (Settings delegate : this.delegates) {
            try {
                return delegate.getImpl(name);
            }
            catch (IllegalArgumentException ex) {
                e = ex;
            }
        }
        throw e;
    }

    public boolean isSetImpl(String aName) {
        for (Settings delegate : this.delegates) {
            if (!delegate.isSetImpl(aName)) continue;
            return true;
        }
        return false;
    }

    public Iterator listImpl() {
        boolean workedAtAll = false;
        HashSet settingList = new HashSet();
        UnsupportedOperationException e = null;
        for (Settings delegate : this.delegates) {
            try {
                Iterator list = delegate.listImpl();
                while (list.hasNext()) {
                    settingList.add(list.next());
                }
                workedAtAll = true;
            }
            catch (UnsupportedOperationException ex) {
                e = ex;
            }
        }
        if (!workedAtAll) {
            throw e == null ? new UnsupportedOperationException() : e;
        }
        return settingList.iterator();
    }
}

