package app.actions;

import java.util.Map;

import app.model.Model;

import com.opensymphony.xwork2.ActionContext;
import com.opensymphony.xwork2.ActionSupport;

public class CheckBid extends ActionSupport {

	private static final long serialVersionUID = 1L;

	private String itemID = null;

	private Integer bidPrice = null;

	public String getItemID() {
		return itemID;
	}

	public void setItemID(String itemID) {
		this.itemID = itemID;
	}

	public Integer getBidPrice() {
		return bidPrice;
	}

	public void setBidPrice(Integer bidPrice) {
		this.bidPrice = bidPrice;
	}

	public String execute() throws Exception {

		if (!Model.validID(itemID)) {
			addActionError("Invalid item ID. Please input again.");

			return ERROR;
		}

		Map<String, Object> session = ActionContext.getContext().getSession();
		Integer hBid = Model.currentHighestBid(itemID);
		if (bidPrice.intValue() > hBid.intValue()) {
			session.put("item", itemID);

			return "highestBid";
		} else {
			session.put("highestBid", hBid);
			session.put("item", itemID);
			bidPrice = null;

			return "notHighestBid";
		}
	}

}