<%@ page language="java" contentType="text/html; charset=UTF-8"
	pageEncoding="UTF-8"%>
<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c"%>
<%@ page import="java.util.*" import="org.hibernate.*"
	import="org.hibernate.stat.*" import="edu.buffalo.cse510.beans.*"
	import="edu.buffalo.cse510.dao.*"
	import="edu.buffalo.cse510.hibernate.*"%>
<!DOCTYPE html PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN" "http://www.w3.org/TR/html4/loose.dtd">
<html>
<head>
<%@ include file="/includes/header.jsp"%>
<title>Hibernate Demo Iteration #4</title>
<%
  Statistics stats = HibernateUtil.getSessionFactory().getStatistics();
  stats.clear();
  long queryCount = -1;
  long fetchCount = -1;
  //
  // Use getCurrentSession to get a session associated with the current thread. Since Tomcat
  // does thread pooling, the reuse of a thread may result in the reuse of a previously used
  // hibernate session. This is not ideal for production environments- Tomcat and Hibernate
  // may get "confused" in certain circumstances (which are hard to debug, by the way). So,
  // ideally, you should manage your own Hibernate sessions. See the Hibernate docs for more
  // information.
  //
  Session hsession = HibernateUtil.getSessionFactory().getCurrentSession();
  hsession.setFlushMode(FlushMode.MANUAL);
  Transaction tx = null;
  try {
    tx = hsession.beginTransaction();
    UniversityDAO uniDAO = new UniversityDAO(hsession);
    List<University> uniList = uniDAO.findAll();
    pageContext.setAttribute("uniList", uniList);
    LocationDAO locDAO = new LocationDAO(hsession);
    List<Location> locList = locDAO.findAll();
    tx.commit();
    fetchCount = stats.getEntityFetchCount();
    queryCount = stats.getQueryExecutionCount();
  }
  catch (Exception e) {
    if (tx != null && tx.isActive()) {
      hsession.getTransaction().rollback();
    }
    throw e;
  }
  finally {
    if (hsession.isOpen()) {
      hsession.close();
    }
  }
%>
</head>

<body>
<div id="wrapper">

<h2>First Hibernate Demo: Test-Driving</h2>

<div class="form-container">

<p>This example improves on Iteration #3 by retrieving all locations
in a single query (as opposed to 138). Note that it is not necessary to
put the location beans in a variable for view processing- Hibernate
automatically populates and associates all Location objects with their
corresponding University beans. Also note that we do not need to wait
for the view to process in order to close the session since all Location
beans have already been populated!</p>

<p>The number of queries executed is <b><%=queryCount%></b> and the
number of fetches from the database is <b><%=fetchCount%></b>. Note that
there are 3217 records in universities and 138 in locations. This is now
much better- almost optimal actually. However, we can still squeeze a
bit more of performance from our application by reducing the number of
queries executed from 2 to 1. We do that in the next iteration.</p>

<p>Once you are done, you may <a
	href="<%=session.getServletContext().getContextPath() + "/"%>">go
back to the main page</a>.</p>

<table class="resultset">
	<tr class="header">
		<th>universityId</th>
		<th>locationId</th>
		<th>locationName</th>
		<th>universityName</th>
	</tr>
	<c:set var="id" value="0" />
	<c:set var="style" value="even" />
	<c:forEach var="uni" items="${uniList}">
		<tr class="${style}">
			<td>${uni.universityId}</td>
			<td>${uni.location.locationId}</td>
			<td>${uni.location.locationName}</td>
			<td>${uni.universityName}</td>
		</tr>
		<c:set var="id" value="${id + 1}" />
		<c:if test="${id % 2 == 1}">
			<c:set var="style" value="odd" />
		</c:if>
		<c:if test="${id % 2 == 0}">
			<c:set var="style" value="even" />
		</c:if>
	</c:forEach>
</table>
</div>
</div>
</body>
</html>