<%@ page language="java" contentType="text/html; charset=UTF-8"
	pageEncoding="UTF-8"%>
<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c"%>
<%@ page import="java.util.*" import="org.hibernate.*"
	import="org.hibernate.stat.*" import="edu.buffalo.cse510.beans.*"
	import="edu.buffalo.cse510.dao.*"
	import="edu.buffalo.cse510.hibernate.*"%>
<!DOCTYPE html PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN" "http://www.w3.org/TR/html4/loose.dtd">
<html>
<head>
<%@ include file="/includes/header.jsp"%>
<title>Hibernate Demo Iteration #6</title>
</head>

<body>
<div id="wrapper">

<h2>First Hibernate Demo: Test-Driving</h2>

<div class="form-container">

<p>This example displays data collected by the UniversityListAction and
placed in the request object.</p>

<table class="resultset">
	<tr class="header">
		<th>universityId</th>
		<th>locationId</th>
		<th>locationName</th>
		<th>universityName</th>
	</tr>
	<c:set var="id" value="0" />
	<c:set var="style" value="even" />
	<c:forEach var="uni" items="${uniList}">
		<tr class="${style}">
			<td>
			  <form action="universityEdit.do" method="POST">
	            <input type="hidden" name="universityId" value="${uni.universityId}"/>
		        <input type="submit" value="Edit ${uni.universityId}" class="button"/>
		      </form>
		    </td>
			<td>${uni.location.locationId}</td>
			<td>${uni.location.locationName}</td>
			<td>${uni.universityName}</td>
		</tr>
		<c:set var="id" value="${id + 1}" />
		<c:if test="${id % 2 == 1}">
			<c:set var="style" value="odd" />
		</c:if>
		<c:if test="${id % 2 == 0}">
			<c:set var="style" value="even" />
		</c:if>
	</c:forEach>
</table>
</div>
</div>
</body>
</html>