package common;

import java.io.File;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class FunctionLib {
	public static Node root(String xqfile) {
		try {
			DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();

			DocumentBuilder db = dbf.newDocumentBuilder();
			Document doc = db.parse(new File(xqfile));
			return doc;
		} catch (Exception e) {
			e.printStackTrace();
		}

		return null;
	}

	public static ResultList children(Node node) {
		NodeList nl = node.getChildNodes();
		ResultList outResult = new ResultList();
		for (int i = 0; i < nl.getLength(); i++) {
			Node child = nl.item(i);
			if (child instanceof Element || child instanceof Text)
				outResult.add(child);
		}

		return outResult;
	}

	public static ResultList parent(Node node) {
		ResultList outResult = new ResultList();
		outResult.add(node.getParentNode());

		return outResult;
	}

	public static String tag(Node node) {
		return node.getNodeName();
	}

}
