/*
 * Copyright 1999 by Brown University Computer Science
 * 115 Waterman Street, 4th Floor, Providence, Rhode Island, 02906, U.S.A
 * All rights reserved.
 *
 * Permission is hereby granted for free use and modification of this
 * software.  However, this copyright must remain at all times.
 * Re-distribution is restricted to those with the express written consent
 * of the copyright holder.  Permission can be obtained by mailing
 * cs015headtas@cs.brown.edu.  
 */

package NGP;

/**
 * Specifies that all classes implementing it can have
 * their color set and accessed.  It also contains the constant for 
 * the default gray that a Java component uses.
 *
 * @see <a href="http://java.sun.com/products/jdk/1.2/docs/api/java/awt/Color.html">java.awt.Color</a>
 *
 * @author Matt Chotin (<a href="mailto:mhc@cs.brown.edu">mhc</a>)
 */

public interface Colorable {
	
  /** The default color of Java components. */
  public java.awt.Color DEFAULT_GRAY = new java.awt.Color(204,204,204);
	
  /** 
   * Set the color of the implementing object.
   *
   * @param c the color to set the <code>Colorable</code>
   * @see #getColor() getColor
   */
  public void setColor(java.awt.Color c);
	
  /**
   * Get the color of the implementing object.
   *
   * @return the color of the <code>Colorable</code>
   * @see #setColor(java.awt.Color) setColor
   */
  public java.awt.Color getColor();

}

