/*
 * Copyright 1999 by Brown University Computer Science
 * 115 Waterman Street, 4th Floor, Providence, Rhode Island, 02906, U.S.A
 * All rights reserved.
 *
 * Permission is hereby granted for free use and modification of this
 * software.  However, this copyright must remain at all times.
 * Re-distribution is restricted to those with the express written consent
 * of the copyright holder.  Permission can be obtained by mailing
 * cs015headtas@cs.brown.edu.  
 */

package NGP.Containers;

//an import statement means I can refer to a class as if I specified the
//whole package
import javax.swing.ButtonGroup;
import javax.swing.AbstractButton;
import java.awt.Component;

/**
 * A subclass of Row that will group radio buttons together so that
 * only one will be selected at a time.  It contains the Swing ButtonGroup
 * and simply overrides the {@link #add(Component) add} and
 * {@link #remove(Component) remove} methods to take the ButtonGroup into
 * account.
 *
 * @see NGP.Containers.RadioColumn
 * @see <a href="http://java.sun.com/products/jdk/1.2/docs/api/javax/swing/ButtonGroup.html">javax.swing.ButtonGroup</a>
 * @see <a href="http://java.sun.com/products/jdk/1.2/docs/api/javax/swing/AbstractButton.html">javax.swing.AbstractButton</a>
 *
 * @author Matt Chotin (<a href="mailto:mhc@cs.brown.edu">mhc</a>)
 */

public class RadioRow extends Row {

  /** The ButtonGroup to make sure only one button is selected at a time. */
  private ButtonGroup _buttonGroup;

  /**
   * Create the radio row.
   *
   * @param container the graphical container for the row
   */
  public RadioRow(NGP.Container container) {
    super(container);

    _buttonGroup = new ButtonGroup();
  }

  /**
   * Overriden method to take the ButtonGroup into account.  The user does
   * not normally need to call this method.
   *
   * @param comp component to add to the row
   * @return returns a Component; you generally do not need to do anything with
   * this
   */
  public Component add(Component comp) {
    Component temp = super.add(comp);
    _buttonGroup.add((AbstractButton) comp);
    return temp;
  }

  /**
   * Remove the component from the container.
   * @param comp the component to remove
   */
  public void remove(Component comp) {
    super.remove(comp);
    _buttonGroup.remove((AbstractButton) comp);
  }

}
